<?php

//the global file operation
include("../public/impOpreation.php");

//global varable
global $showoutside;

//to check if the page from .htacess
//$showoutside = $_GET['sn'];
// get the config file
include_once("../public/config.php");
include_once("dailyentryfun.php");

//here the db files that include in the file
// GOES HERE ....................
include("../public/include_dao.php");

//Bank
require_once('../models/dao/BankDAO.class.php');
require_once('../models/dto/Bank.class.php');
require_once('../models/mysql/BankMySqlDAO.class.php');
require_once('../models/mysql/ext/BankMySqlExtDAO.class.php');

//Bankaccount
require_once('../models/dao/BankaccountDAO.class.php');
require_once('../models/dto/Bankaccount.class.php');
require_once('../models/mysql/BankaccountMySqlDAO.class.php');
require_once('../models/mysql/ext/BankaccountMySqlExtDAO.class.php');

//Accountmovement
require_once('../models/dao/AccountmovementDAO.class.php');
require_once('../models/dto/Accountmovement.class.php');
require_once('../models/mysql/AccountmovementMySqlDAO.class.php');
require_once('../models/mysql/ext/AccountmovementMySqlExtDAO.class.php');

require_once('../models/dao/YoutubeLinkDAO.class.php');
require_once('../models/dto/YoutubeLink.class.php');
require_once('../models/mysql/YoutubeLinkMySqlDAO.class.php');
require_once('../models/mysql/ext/YoutubeLinkMySqlExtDAO.class.php');
//Breadcrumb
require_once("../library/breadcrumb.php");



//get the do the action
$do = $_GET['do'];

$langs = $_SESSION['erp_lang'];
include_once("../views/languages/$langs/success.php");
include_once("../views/languages/$langs/error.php");

/* ======================

  Controller Name :- saveCTRL اضافة وتعديل وعرض الخزن

  OPERTATION in Controller

  1-display add form
  2- add in Save tbl
  3-insert into savedaily tbl
  4-display sucess or error
  5-display show form
  6-edit in Save data

  ======================== */


//here the global templates
$smarty->display("header.html");


//here goes the instances and general variables
//Bank
$myBank = new Bank();
$myBankRecord = new BankMySqlDAO();
$myBankEx = new BankMySqlExtDAO();

//Bankaccount
$myBankaccount = new Bankaccount();
$myBankaccountRecord = new BankaccountMySqlDAO();
$myBankaccountEx = new BankaccountMySqlExtDAO();

//Accountmovement
$myAccountmovement = new Accountmovement();
$myAccountmovementRecord = new AccountmovementMySqlDAO();

//Breadcrumb
$breadcrumbObject = new Breadcrumb();


//Accountstree
$accountsTree = new Accountstree();
$accountsTreeDAO = new AccountstreeMySqlDAO();
$accountsTreeEX = new AccountstreeMySqlExtDAO();


//Dailyentry
$dailyEntry = new Dailyentry();
$dailyEntryDAO = new DailyentryMySqlDAO();
$dailyEntryEX = new DailyentryMySqlExtDAO();

//Dailyentrycreditor دائن
$dailyEntryCreditor = new Dailyentrycreditor();
$dailyEntryCreditorDAO = new DailyentrycreditorMySqlDAO();
$dailyEntryCreditorEX = new DailyentrycreditorMySqlExtDAO();

//Dailyentrydebtor مدين
$dailyEntryDebtor = new Dailyentrydebtor();
$dailyEntryDebtorDAO = new DailyentrydebtorMySqlDAO();
$dailyEntryDebtorEX = new DailyentrydebtorMySqlExtDAO();

$youtubeLink = new YoutubeLink();
$youtubeLinkDAO = new YoutubeLinkMySqlDAO();
$youtubeLinkEX = new YoutubeLinkMySqlExtDAO();
//check and use the condetion that suite this action
if (empty($do)) {
    //here the permssion check
    include_once("../public/authentication.php");


    $bankData = loadBanks();
    $smarty->assign("bankData", $bankData);

    //breadcrumb
    $breadcrumbObject->add('ادارة البنوك><a href="bankaccountController.php?do=show">حسابات البنوك</a> > اضافة حساب', 'bankaccountController.php', 0);
    //Now output the navigation.
    $breadCrumb = $breadcrumbObject->output();
    $smarty->assign("breadCrumb", $breadCrumb);



    //here the smarty templates
    $smarty->display("bankaccountview/add.html");
} elseif ($do == "add") {

    //here the permssion check
    include_once("../public/authentication.php");

    try {
        // here the function that do the action
        add();
        header("location:?do=sucess");
    } catch (Exception $e) {
        header("location:?do=error");
    }
} elseif ($do == "show") {
    //here the permssion check
    include_once("../public/authentication.php");


    $youtubes = $youtubeLinkDAO->queryAll();
    $smarty->assign("youtubes", $youtubes);


    $bankData = loadBanks();
    $smarty->assign("bankData", $bankData);


    $bankId = $_REQUEST['bankid'];



    if (isset($bankId) && $bankId != "-1") {
        $bankaccountData = showByBankId($bankId);
    } else {
        $bankaccountData = showAll();
    }


    $smarty->assign("bankaccountData", $bankaccountData);


    //breadcrumb
    $breadcrumbObject->add('ادارة البنوك><a href="bankaccountController.php?do=show">حسابات البنوك</a> > عرض الحسابات', 'bankaccountController.php', 0);
    //Now output the navigation.
    $breadCrumb = $breadcrumbObject->output();
    $smarty->assign("breadCrumb", $breadCrumb);



    $smarty->display("bankaccountview/show.html");



    $smarty->assign("customCheck", 1);
} elseif ($do == "returndelete") {
    include_once("../public/authentication.php");

    $accountId = $_GET['accountid'];
    try {
        // here the function that do the action
        returndelete($accountId);
        header("location:?do=sucess");
    } catch (Exception $e) {
        header("location:?do=error");
    }
} elseif ($do == "deletetemp") {
    include_once("../public/authentication.php");

    $accountId = $_GET['accountid'];
    try {
        // here the function that do the action
        deletetemp($accountId);
        header("location:?do=sucess");
    } catch (Exception $e) {
        header("location:?do=error");
    }
} elseif ($do == "edit") {
    //here the permssion check
    include_once("../public/authentication.php");

    $loadData = edit();
    $smarty->assign("loadData", $loadData);

    $bankData = loadBanks();
    $smarty->assign("bankData", $bankData);


    //breadcrumb
    $breadcrumbObject->add('ادارة البنوك><a href="bankaccountController.php?do=show">حسابات البنوك</a> > تعديل حساب بنك', 'bankaccountController.php', 0);
    //Now output the navigation.
    $breadCrumb = $breadcrumbObject->output();
    $smarty->assign("breadCrumb", $breadCrumb);


    $smarty->display("bankaccountview/edit.html");
}
//edit  update
elseif ($do == "update") {

    //here the permssion check
    include_once("../public/authentication.php");
    //
    try {
        // here the function that do the action
        update();
        header("location:?do=sucess");
    } catch (Exception $e) {
        header("location:?do=error");
    }
} elseif ($do == "details") {
    //here the permssion check
    include_once("../public/authentication.php");

    $loadData = edit();
    $smarty->assign("loadData", $loadData);

    $bankData = loadBanks();
    $smarty->assign("bankData", $bankData);


    //breadcrumb
    $breadcrumbObject->add('ادارة البنوك><a href="bankaccountController.php?do=show">حسابات البنوك</a> > تعديل حساب بنك', 'bankaccountController.php', 0);
    //Now output the navigation.
    $breadCrumb = $breadcrumbObject->output();
    $smarty->assign("breadCrumb", $breadCrumb);


    $smarty->display("bankaccountview/details.html");
}

//edit  update
elseif ($do == "executeOperation") {

    //here the permssion check
    include_once("../public/authentication.php");

    // here the function that do the action
    executeOperation();



    $bankData = loadBanks();
    $smarty->assign("bankData", $bankData);

    $bankaccountData = showAll();
    $smarty->assign("bankaccountData", $bankaccountData);


    //breadcrumb
    $breadcrumbObject->add('ادارة البنوك><a href="bankaccountController.php?do=show">حسابات البنوك</a> > عرض الحسابات', 'bankaccountController.php', 0);
    //Now output the navigation.
    $breadCrumb = $breadcrumbObject->output();
    $smarty->assign("breadCrumb", $breadCrumb);




    $smarty->display("bankaccountview/show.html");

    $smarty->assign("customCheck", 1);
} elseif ($do == "sucess") {

    //here the smarty templates
    $smarty->display("succes.html");
} elseif ($do == "error") {

    //here the smarty templates
    $smarty->display("error.html");
}




$smarty->assign("customBankAcount", 1);
$smarty->assign("customValidation", 1);
//here the global templates
$smarty->display("footer.html");

/* ===============================
  function in this CONTROLLER
  ================================ */

function loadBanks() {
    //to use the variable out side the funcion
    global $myBankRecord;

    $bankData = $myBankRecord->queryByCondition(0);

    return $bankData;
}

// add in bankaccount tbl
function add() {

    //to use the variable out side the funcion
    global $myBankaccount;
    global $myBankaccountRecord;
    global $accountsTreeDAO;
    global $accountsTree;
    global $myBankRecord;
    //Dailyentry
    global $dailyEntry;
    global $dailyEntryDAO;

    //Dailyentrycreditor دائن
    global $dailyEntryCreditor;
    global $dailyEntryCreditorDAO;

    //Dailyentrydebtor مدين
    global $dailyEntryDebtor;
    global $dailyEntryDebtorDAO;
    //Transaction
    $mytransactions = new Transaction();

    $bankId = $_POST['bankid'];
    $accountName = $_POST['accountname'];
    $accountNumber = $_POST['accountnumber'];
    $accountBeginingbalance = $_POST['accountbeginingbalance'];
    $accountCurrencytype = $_POST['accountcurrencytype'];
    $comment = $_POST['comment'];
    $visa = (int) $_POST['visa'];
    $visaDisPer = (float) $_POST['visaDisPer'];

    //add in bankaccount tbl
    $myBankaccount->accountbeginingbalance = $accountBeginingbalance;
    $myBankaccount->accountcurrencytype = $accountCurrencytype;
    $myBankaccount->accountdate = date("Y-m-d");
    $myBankaccount->accountname = $accountName;
    $myBankaccount->accountnumber = $accountNumber;
    $myBankaccount->bankid = $bankId;
    $myBankaccount->visa = $visa;
    $myBankaccount->visaDisPer = $visaDisPer;
    $myBankaccount->treeId = $visaDisPer;
    $myBankaccount->conditions = 0;
    $myBankaccount->userid = $_SESSION["userid"];

    $dailyEntry->entryComment = 'تم اضافة حساب ' . $accountName;
    $dailyEntryDebtorArray = array();
    $dailyEntryDebtor->value = $accountBeginingbalance;

    $dailyEntryCreditorArray = array();
    $dailyEntryCreditor->value = $accountBeginingbalance;
    $dailyEntryCreditor->accountstreeid = 121;
    array_push($dailyEntryCreditorArray, $dailyEntryCreditor);

    $bankData = $myBankRecord->load($bankId);


    try {
        $accountId = $myBankaccountRecord->insert($myBankaccount, $comment);

        if ($accountBeginingbalance > 0) {

            //insert in accountmovement tbl
            insertAccountmovement(0, $accountBeginingbalance, 0, $accountBeginingbalance, "اضافة حساب فى بنك", $accountId, $accountId, $bankId, "bankaccountController.php");
        }
        //$treeid = addTreeElement($accountName, $bankTreeId, 3, 0, 1, '', 0, 0);
        $treeid = addTreeElement("$accountName / $bankData->bankname", 38, 3, 0, 1, '', 0, 0);
        $myBankaccount->treeId = $treeid;
        $myBankaccountRecord->update($myBankaccount, $comment);

        $dailyEntryDebtor->accountstreeid = $treeid;
        array_push($dailyEntryDebtorArray, $dailyEntryDebtor);


        insertEntery($dailyEntry, $dailyEntryDebtorArray, $dailyEntryCreditorArray, 1);

        $mytransactions->commit();

        $message = 'تمت العملية بنجاح';
    } catch (Exception $ex) {
        $mytransactions->rollback();
        $message = 'عفوا لقد حدث خطأ';
    }
}

//show
function showAll() {
    //to use the variable out side the funcion
    global $myBankaccountEx;

    $bankaccountData = $myBankaccountEx->queryWithOrder();

    return $bankaccountData;
}

//show by bankid
function showByBankId($bankid) {
    //to use the variable out side the funcion
    global $myBankaccountEx;

    $bankaccountData = $myBankaccountEx->queryWithBankId($bankid);

    return $bankaccountData;
}

//deletetemp Store tbl
function deletetemp($accountId) {
    //to use the variable out side the funcion
    global $myBankaccount;
    global $myBankaccountEx;


    try {
        if ($accountId != "") {

            $myBankaccount->accountdate = date("Y-m-d");
            $myBankaccount->conditions = 1;
            $myBankaccount->userid = $_SESSION["userid"];
            $myBankaccount->accountid = $accountId;



            $myBankaccountEx->updateConditions($myBankaccount);

            $note = "success";
        } else {

            $note = "حدث خطأ أثناء إخفاء حساب البنك";
        }
    } catch (Exception $e) {
        $note = "حدث خطأ أثناء إخفاء حساب البنك";
    }

    return $note;
}

//returndelete Store tbl
function returndelete($accountId) {
    //to use the variable out side the funcion
    global $myBankaccount;
    global $myBankaccountEx;


    try {
        if ($accountId != "") {


            $myBankaccount->accountdate = date("Y-m-d");
            $myBankaccount->conditions = 0;
            $myBankaccount->userid = $_SESSION["userid"];
            $myBankaccount->accountid = $accountId;



            $myBankaccountEx->updateConditions($myBankaccount);



            $note = "success";
        } else {
            $note = "حدث خطأ أثناء اظهار حساب البنك";
        }
    } catch (Exception $e) {
        $note = "حدث خطأ أثناء اظهار حساب البنك";
    }

    return $note;
}

//edit from Store tbl
function edit() {
    //to use the variable out side the funcion
    global $myBankaccountEx;

    //get Variable
    $accountId = $_GET['accountid'];

    $loadData = $myBankaccountEx->loadBankAccount($accountId);

    return $loadData;
}

function update() {
    global $myBankRecord;
    global $myBankaccount;
    global $myBankaccountRecord;
    global $accountsTreeDAO;
    global $accountsTree;

    //Transaction
    $utransactions = new Transaction();

    $bankId = $_POST['bankid'];
    $accountName = $_POST['accountname'];
    $accountNumber = $_POST['accountnumber'];
    $accountBeginingbalance = $_POST['accountbeginingbalance'];
    $accountCurrencytype = $_POST['accountcurrencytype'];
    $comment = $_POST['comment'];
    $visa = (int) $_POST['visa'];
    $visaDisPer = (float) $_POST['visaDisPer'];
    $accountDate = $_POST['accountdate'];
    $conditions = $_POST['conditions'];
    $accountId = $_POST['accountid'];

    $oldData = $myBankaccountRecord->load($accountId);
    //update data in bankaccount tbl
    $myBankaccount->accountbeginingbalance = $accountBeginingbalance;
    $myBankaccount->accountcurrencytype = $accountCurrencytype;
    $myBankaccount->accountdate = $accountDate;
    $myBankaccount->accountname = $accountName;
    $myBankaccount->accountnumber = $accountNumber;
    $myBankaccount->bankid = $bankId;
    $myBankaccount->visa = $visa;
    $myBankaccount->visaDisPer = $visaDisPer;
    $myBankaccount->treeId = $oldData->treeId;
    $myBankaccount->conditions = $conditions;
    $myBankaccount->userid = $_SESSION["userid"];
    $myBankaccount->accountid = $accountId;

    try {
        $myBankaccountRecord->update($myBankaccount, $comment);

        $treeId = $oldData->treeId;
        $treedata = $accountsTreeDAO->load($treeId);
        $bankData = $myBankRecord->load($bankId);
        $treedata->name = "$accountName / $bankData->bankname";
        $treedata->customName = "$accountName / $bankData->bankname";

        $var = editTreeElement($treedata);
        $utransactions->commit();

        $message = 'تمت العملية بنجاح';
    } catch (Exception $ex) {
        $utransactions->rollback();
        $message = 'عفوا لقد حدث خطأ';
    }
}

function executeOperation() {
    //to use the variable out side the funcion
    global $myBankaccountRecord;
    global $smarty;

    $outputString;

    $operationType = $_POST['operation'];
    $smarty->assign("operationType", $operationType);

    $choosedItemArr = $_POST['choosedItem'];
    //print_r($choosedItemArr);
    if (count($choosedItemArr) > 0) {
        foreach ($choosedItemArr as $accountId) {

            //get store name
            $bankaccountData = $myBankaccountRecord->load($accountId);
            $accountName = $bankaccountData->accountname;

            if ($operationType == '1') {
                //tempdelete
                $note = deletetemp($accountId);
                if ($note != "success") {
                    $outputString .= $accountName . ": " . $note . "<br/>";
                } else {
                    $outputString .= $accountName . ": " . "تمت العملية بنجاح <br/>";
                }
            } elseif ($operationType == "2") {
                //returndelete
                $note = returndelete($accountId);
                if ($note != "success") {
                    $outputString .= $accountName . ": " . $note . "<br/>";
                } else {
                    $outputString .= $accountName . ": " . "تمت العملية بنجاح <br/>";
                }
            } elseif ($operationType == "3") {
                //returndelete
                $note = delete($accountId);
                if ($note != "success") {
                    $outputString .= $accountName . ": " . $note . "<br/>";
                } else {
                    $outputString .= $accountName . ": " . "تمت العملية بنجاح <br/>";
                }
            }
        }

        $smarty->assign("outputString", $outputString);
    }
}

// get accountbeginingbalance from  bankaccount tbl
function getAccountBalanceBefore($accountid) {

    //to use the variable out side the funcion
    global $myBankaccountRecord;

    $bankaccountData = $myBankaccountRecord->load($accountid);
    $accountBalance = $bankaccountData->accountbeginingbalance;

    return $accountBalance;
}

// get accountbeginingbalance and plus from Bankaccount tbl
function getAccountBalanceAndPlus($accountid, $accountmovementamount) {

    //to use the variable out side the funcion
    global $myBankaccount;
    global $myBankaccountRecord;

    $bankaccountData = $myBankaccountRecord->load($accountid);
    $accountBalanceBefore = $bankaccountData->accountbeginingbalance;

    $accountBalanceAfter = $accountBalanceBefore + $accountmovementamount;

    return array($accountBalanceBefore, $accountBalanceAfter);
}

// get accountbeginingbalance and minus from Bankaccount tbl
function getAccountBalanceAndMins($accountid, $accountmovementamount) {

    //to use the variable out side the funcion
    global $myBankaccount;
    global $myBankaccountRecord;

    $bankaccountData = $myBankaccountRecord->load($accountid);
    $accountBalanceBefore = $bankaccountData->accountbeginingbalance;

    $accountBalanceAfter = $accountBalanceBefore - $accountmovementamount;

    return array($accountBalanceBefore, $accountBalanceAfter);
}

// update in BankAccount tbl
function updateBankAccount($accountid, $accountBalanceAfter) {

    //to use the variable out side the funcion
    global $myBankaccount;
    global $myBankaccountEx;

    //update accountbeginingbalance in BankAccount tbl
    $myBankaccount->accountbeginingbalance = $accountBalanceAfter;
    $myBankaccount->userid = $_SESSION['userid'];
    $myBankaccount->accountid = $accountid;

    $myBankaccountEx->updateAccountbeginingbalance($myBankaccount);
}

// insert in Savedaily tbl
function insertAccountmovement($accountbefore, $accountamount, $accountmovementtype, $accountafter, $processname, $accountmovementmodelid, $accountid, $bankid, $tablename) {

    //to use the variable out side the funcion
    global $myAccountmovement;
    global $myAccountmovementRecord;


    //insert in Accountmovement tbl
    $myAccountmovement->accountid = $accountid;
    $myAccountmovement->accountmovementafter = $accountafter;
    $myAccountmovement->accountmovementamount = $accountamount;
    $myAccountmovement->accountmovementbefore = $accountbefore;
    $myAccountmovement->accountmovementdate = date("Y-m-d");
    $myAccountmovement->accountmovementmodelid = $accountmovementmodelid;
    $myAccountmovement->accountmovementtype = $accountmovementtype;
    $myAccountmovement->bankid = $bankid;
    $myAccountmovement->processname = $processname;
    $myAccountmovement->tablename = $tablename;
    $myAccountmovement->userid = $_SESSION['userid'];

    $myAccountmovementRecord->insert($myAccountmovement);
}

?>