<?php

/*
 * awframework from aw.inc present aw controller
 * it will help you develop easy and fast with secure tools
 * you can edit and add what you feel right
 * don't change in strucure of file
 */

require_once("imp/_imp.php");

class Controllers {

    //public vars
    public $smarty;
    public $hosturl;

    // it will run in everytime with
    // default requried
    public function __construct() {
        require_once("../public/aw_config.php");
        require_once("imp/_autho.php"); //general functions
        $this->smarty = $smarty;
        $this->hosturl = $hosturl;


        //here will call all php pages
        require_once("_header.php");
    }

    //here the frist page and
    //the frist action in this class
    public function index() {
        $idss = filter_input(INPUT_GET, 'id');
        $departss = '';

        if (!empty($idss)) {

            $ids = explode(",", $idss);

            $deptId = $ids[0];
            $countryId = $ids[1];
            $regionId = $ids[2];


            if ($regionId != -1 && $countryId != -1 && $deptId != -1) {      ##   have country id and region id and dept id
                $departss = R::getAll('select distinct f.* from firms f
                                join depart d                on d.id = f.departid
                                join  firmbranches b        on b.firmid = f.id
                                where  b.regionid = ? and f.departid = ?', [$regionId, $deptId]);
                $this->smarty->assign('type', 'firm');
            } elseif ($regionId != -1 && $countryId != -1 && $deptId == -1) {   ## only have country id  and region id
                $departss = R::getAll('select distinct d.* from depart d
                                join firms f                on d.id = f.departid
                                join  firmbranches b        on b.firmid = f.id
                                where  b.regionid = ?', [$regionId]);
                $this->smarty->assign('type', 'dept');
            } elseif ($countryId != -1 && $regionId == -1 && $deptId == -1) {       ## only have  country id
                $departss = R::getAll('select distinct d.* from depart d
                                join firms f                on d.id = f.departid
                                join  firmbranches b        on b.firmid = f.id
                                join  region r              on b.regionid = r.id
                                where  r.countryid = ?', [$countryId]);
                $this->smarty->assign('type', 'dept');
            }
        } else {
        $deptId = -1;
            $countryId = -1;
            $regionId = -1;

            ## depart
            $departss = R::getAll('select  * from depart order by id asc');
            $this->smarty->assign('type', 'dept');
        }



        $this->smarty->assign('departss', $departss);
        
        $this->smarty->assign('countryId', $countryId );
        $this->smarty->assign('regionId', $regionId);
        $this->smarty->assign('deptId', $deptId);



        //here will load the menu show
        $countrys = R::findAll('country', 'hide = 1 order by id asc');
        $this->smarty->assign('countrys', $countrys);

        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        $this->smarty->display('filter.html');
        $this->smarty->display('departments.html');
        $this->smarty->display('footer.html');
    }

    public function getregions() {
        $countryId = filter_input(INPUT_POST, 'countryId');
        //here will load the menu show
        $regions = R::findAll('region', 'hide = 1 and countryid = ?  order by id asc', [$countryId]);
        $result1 = '<option value="-1">اختر الشركة</option>';
        foreach ($regions as $reg) {
            $result1 .='<option value=' . $reg->id . '>' . $reg->name . ' </option>';
        }

        $result2 = '';
        ## depart
        $departs = R::getAll('select distinct d.* from depart d
                                join firms f                on d.id = f.departid
                                join  firmbranches b        on b.firmid = f.id
                                join  region r              on b.regionid = r.id
                                where  r.countryid = ?', [$countryId]);

        foreach ($departs as $dept) {
            $result2 .='<li>';
            $result2 .='<div class="w-deal-in"> ';
            $result2 .= '<img class="img-responsive" style="height: 150px;" src="' . $this->hosturl . '/upload/depart/' . $dept['image'] . '" alt="">';
            $result2 .= '<p>' . $dept ['name'] . '</p>';
            $result2 .= '<div class="w-over"> <a href="' . $this->hosturl . '/firms/showcompanies/' . $dept ['id'] . ',' . $countryId . ',-1">عرض  الشركات </a> </div>';
            $result2 .= '</div>';
            $result2 .= '</li>';
        }

        $output = array(
            //"sEcho" => intval($_GET['sEcho']),
            "result1" => $result1,
            "result2" => $result2
        );

        echo json_encode($output);
    }

    public function getdepts() {
        $countryId = filter_input(INPUT_POST, 'countryId');
        $regionId = filter_input(INPUT_POST, 'regionId');

        //here will load the menu show
        $departs = R::getAll('select distinct d.* from depart d
                                join firms f                on d.id = f.departid
                                join  firmbranches b        on b.firmid = f.id
                                where  b.regionid = ?', [$regionId]);


        $result1 = '<option value="-1">اختر الأقسام</option>';
        $result2 = '';
        ## depart


        foreach ($departs as $dept) {
            $result1 .='<option value=' . $dept['id'] . '>' . $dept['name'] . ' </option>';
            $result2 .='<li>';
            $result2 .='<div class="w-deal-in"> ';
            $result2 .= '<img class="img-responsive" style="height: 150px;" src="' . $this->hosturl . '/upload/depart/' . $dept['image'] . '" alt="">';
            $result2 .= '<p>' . $dept ['name'] . '</p>';
            $result2 .= '<div class="w-over"> <a href="' . $this->hosturl . '/firms/showcompanies/' . $dept ['id'] . ',' . $countryId . ',' . $regionId . '">عرض  الشركات </a> </div>';
            $result2 .= '</div>';
            $result2 .= '</li>';
        }

        $output = array(
            //"sEcho" => intval($_GET['sEcho']),
            "result1" => $result1,
            "result2" => $result2
        );

        echo json_encode($output);
    }

    public function getfirms() {
        $deptId = filter_input(INPUT_POST, 'deptId');
        $regionId = filter_input(INPUT_POST, 'regionId');


        //here will load the menu show
        $firms = R::getAll('select distinct f.* from firms f
                                join depart d                on d.id = f.departid
                                join  firmbranches b        on b.firmid = f.id
                                where  b.regionid = ? and f.departid = ?', [$regionId, $deptId]);


        $result2 = '';
        ## depart


        foreach ($firms as $dept) {
            $result2 .='<li>';
            $result2 .='<div class="w-deal-in"> ';
            $result2 .= '<img class="img-responsive" style="height: 150px;" src="' . $this->hosturl . '/upload/firms/' . $dept['logo'] . '" alt="">';
            $result2 .= '<p>' . $dept ['name'] . '</p>';
            $result2 .= '<div class="w-over"> <a href="' . $this->hosturl . '/firms/companydetail/' . $dept ['id'] . '">التفاصيل</a> </div>';
            $result2 .= '</div>';
            $result2 .= '</li>';
        }

        $output = array(
            "result2" => $result2
        );

        echo json_encode($output);
    }

    public function showcompanies() {
        $idss = filter_input(INPUT_GET, 'id');
        $ids = explode(",", $idss);

        $deptId = $ids[0];
        $countryId = $ids[1];
        $regionId = $ids[2];

        //R::debug(true , 2);

        if ($regionId != -1 && $countryId != -1) {      ##   have country id and region id and dept id
            $firms = R::getAll('select distinct f.* from firms f
                                join depart d                on d.id = f.departid
                                join  firmbranches b        on b.firmid = f.id
                                where  b.regionid = ? and f.departid = ?', [$regionId, $deptId]);
        } elseif ($regionId == -1 && $countryId != -1) {   ## only have country id and dept id
            $firms = R::getAll('select distinct f.* from firms f
                                join depart d                on d.id = f.departid
                                join  firmbranches b        on b.firmid = f.id
                                join  region r              on b.regionid = r.id
                                where  r.countryid = ? and f.departid = ? ', [$countryId, $deptId]);
        } elseif ($countryId == -1 && $regionId != -1) {       ## only have region id and dept id
            $firms = R::getAll('select distinct f.* from firms f
                        join depart d                on d.id = f.departid
                        join  firmbranches b        on b.firmid = f.id
                        where  b.regionid = ? and f.departid = ?', [$regionId, $deptId]);
        } else {         ## only have  dept id
            $firms = R::getAll('select * from firms where  departid = ?', [$deptId]);
            ;
        }



        //R::debug(false);


        $this->smarty->assign('firms', $firms);
        $this->smarty->assign('deptId', $deptId);
        $this->smarty->assign('countryId', $countryId);
        $this->smarty->assign('regionId', $regionId);

        $countrys = R::findAll('country', 'hide = 1 order by id asc');
        $this->smarty->assign('countrys', $countrys);

        if ($regionId != -1) {
            $regions = R::findAll('region', 'hide = 1 and countryid = ?  order by id asc', [$countryId]);
            $this->smarty->assign('regions', $regions);
        }


//call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        $this->smarty->display('firms.html');
        $this->smarty->display('footer.html');
    }

    public function companydetail() {
        $companyId = filter_input(INPUT_GET, 'id');
        $firm = R::load('firms', $companyId);
        $firmBranches = R::findAll('firmbranches', 'firmid = ?', [$companyId]);
        $firmProducts = R::findAll('firmproducts', 'firmid = ?', [$companyId]);
        $firmPackages = R::findAll('packagefirms', 'firmid = ?', [$companyId]);
        $firmFiles = R::findAll('firmfiles', 'firmid = ?', [$companyId]);
        foreach ($firmPackages as $firmPackage) {
            $package = R::load('package', $firmPackage->packageid);
            $firmPackage->packName = $package->name;
            $firmPackage->packPhoto = $package->image;
        }

        $this->smarty->assign('firm', $firm);
        $this->smarty->assign('firmBranches', $firmBranches);
        $this->smarty->assign('firmProducts', $firmProducts);
        $this->smarty->assign('firmPackages', $firmPackages);
        $this->smarty->assign('firmFiles', $firmFiles);

//call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        //$this->smarty->display('pagetitle.html');
        $this->smarty->display('company.html');
        $this->smarty->display('footer.html');
    }

    public function productdetail() {
        $productId = filter_input(INPUT_GET, 'productid');
        $product = R::load('firmproducts', $productId);

        $this->smarty->assign('product', $product);
        $this->smarty->assign('search', filter_input(INPUT_GET, 'search'));

//call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        //$this->smarty->display('pagetitle.html');
        $this->smarty->display('product.html');
        $this->smarty->display('footer.html');
    }

    public function getcomps() {
        $deptId = filter_input(INPUT_POST, 'deptId');
        $regionId = filter_input(INPUT_POST, 'regionId');
        $countryId = filter_input(INPUT_POST, 'countryId');
        $id = filter_input(INPUT_POST, 'id');


        //R::debug(true , 2);

        if ($regionId != -1 && $countryId != -1) {      ##   have country id and region id and dept id
            $firms = R::getAll('select distinct f.* from firms f
                                join depart d                on d.id = f.departid
                                join  firmbranches b        on b.firmid = f.id
                                where  b.regionid = ? and f.departid = ?', [$regionId, $deptId]);
        } elseif ($regionId == -1 && $countryId != -1) {   ## only have country id and dept id
            $firms = R::getAll('select distinct f.* from firms f
                                join depart d                on d.id = f.departid
                                join  firmbranches b        on b.firmid = f.id
                                join  region r              on b.regionid = r.id
                                where  r.countryid = ? and f.departid = ? ', [$countryId, $deptId]);
        } elseif ($countryId == -1 && $regionId != -1) {       ## only have region id and dept id
            $firms = R::getAll('select distinct f.* from firms f
                        join depart d                on d.id = f.departid
                        join  firmbranches b        on b.firmid = f.id
                        where  b.regionid = ? and f.departid = ?', [$regionId, $deptId]);
        } else {         ## only have  dept id
            $firms = R::getAll('select * from firms where  departid = ?', [$deptId]);
            ;
        }



        //R::debug(false);

        if ($id == 'countryX') {
            $regions = R::findAll('region', 'hide = 1 and countryid = ?  order by id asc', [$countryId]);
            $result1 = '<option value="-1">اختر الشركة</option>';
            foreach ($regions as $reg) {
                $result1 .='<option value=' . $reg->id . '>' . $reg->name . ' </option>';
            }
        }

        $result2 = '';


        foreach ($firms as $dept) {
            $result2 .='<li>';
            $result2 .='<div class="w-deal-in">';
            $result2 .= '<img class="img-responsive" style="height: 150px;" src="' . $this->hosturl . '/upload/firms/' . $dept['logo'] . '" alt="">';
            $result2 .= '<p>' . $dept ['name'] . '</p>';
            $result2 .= '<div class="w-over"> <a href="' . $this->hosturl . '/firms/companydetail/' . $dept ['id'] . '">التفاصيل</a> </div>';
            $result2 .= '</div>';
            $result2 .= '</li>';
        }

        $output = array(
            //"sEcho" => intval($_GET['sEcho']),
            "result1" => $result1,
            "result2" => $result2
        );

        echo json_encode($output);
    }

    // at the end of class call
    public function __destruct() {
        //close connection
        R::close();
    }

}
