<?php

//the global file operation
include("../public/impOpreation.php");

//global varable
global $showoutside;

//to check if the page from .htacess
//$showoutside = $_GET['sn'];
// get the config file
include_once("../public/config.php");

//here the db files that include in the file
include("../public/include_dao.php");
//Sparepart
require_once('../models/dao/SparepartDAO.class.php');
require_once('../models/dto/Sparepart.class.php');
require_once('../models/mysql/SparepartMySqlDAO.class.php');
require_once('../models/mysql/ext/SparepartMySqlExtDAO.class.php');
//Sparepartstore
require_once('../models/dao/SparepartstoreDAO.class.php');
require_once('../models/dto/Sparepartstore.class.php');
require_once('../models/mysql/SparepartstoreMySqlDAO.class.php');
require_once('../models/mysql/ext/SparepartstoreMySqlExtDAO.class.php');
//Sparepartstoredetail
require_once('../models/dao/SparepartstoredetailsDAO.class.php');
require_once('../models/dto/Sparepartstoredetail.class.php');
require_once('../models/mysql/SparepartstoredetailsMySqlDAO.class.php');
require_once('../models/mysql/ext/SparepartstoredetailsMySqlExtDAO.class.php');
//Sparepartstorereport
require_once('../models/dao/SparepartstorereportDAO.class.php');
require_once('../models/dto/Sparepartstorereport.class.php');
require_once('../models/mysql/SparepartstorereportMySqlDAO.class.php');
require_once('../models/mysql/ext/SparepartstorereportMySqlExtDAO.class.php');

//get the do the action
$do = $_GET['do'];

$langs = $_SESSION['erp_lang'];
include_once("../views/languages/$langs/success.php");
include_once("../views/languages/$langs/error.php");

/* ======================

  Controller Name :-sparePartController

  OPERTATION in Controller

  1-display add form
  2- add in sparepartstoredetail table
  3-display sucess or error
  4-display show and delete
  5-display edit
  ======================== */

//here the global templates
$smarty->display("header.html");

//Sparepart
$sparePart = new Sparepart();
$sparePartDAO = new SparepartMySqlDAO();
$sparePartExt = new SparepartMySqlExtDAO();
//Sparepartstore
$sparePartStore = new Sparepartstore();
$sparePartStoreDAO = new SparepartstoreMySqlDAO();
$sparePartStoreExt = new SparepartstoreMySqlExtDAO();
//Sparepartstoredetail
$sparePartDetail = new Sparepartstoredetail();
$sparePartDetailDAO = new SparepartstoredetailsMySqlDAO();
$sparePartDetailExt = new SparepartstoredetailsMySqlExtDAO();
//Sparepartstorereport
$sparePartReport = new Sparepartstorereport();
$sparePartReportDAO = new SparepartstorereportMySqlDAO();
$sparePartReportExt = new SparepartstorereportMySqlExtDAO();

//check and use the condetion that suite this action
if (empty($do)) {
    //here the permssion check
    include_once("../public/authentication.php");

    //here the smarty templates
    $smarty->display("sparePartview/add.html");
} elseif ($do == "add") {
    include_once("../public/authentication.php");
    try {
        add();
        header("location:?do=sucess");
    } catch (Exception $e) {
        header("location:?do=error");
    }
} elseif ($do == "show") {
    include_once("../public/authentication.php");

    //$sparePartsData =
    show();
    //$smarty->assign("sparePartsData",$sparePartsData);

    $smarty->display("sparePartview/show.html");

    $smarty->assign("customCheck", 1);
} elseif ($do == "delete") {
    include_once("../public/authentication.php");

    $sparepartid = $_GET['id'];

    try {
        delete($sparepartid);
        header("location:?do=sucess");
    } catch (Exception $e) {
        header("location:?do=error");
    }
} elseif ($do == "returndelete") {
    include_once("../public/authentication.php");

    $sparepartid = $_GET['id'];
    try {
        returndelete($sparepartid);
        header("location:?do=sucess");
    } catch (Exception $e) {
        header("location:?do=error");
    }
} elseif ($do == "deletetemp") {
    include_once("../public/authentication.php");

    $sparepartid = $_GET['id'];
    try {
        deletetemp($sparepartid);
        header("location:?do=sucess");
    } catch (Exception $e) {
        header("location:?do=error");
    }
} elseif ($do == "edit") {
    include_once("../public/authentication.php");

    $loadData = edit();
    $smarty->assign("loadData", $loadData);

    $smarty->display("sparePartview/edit.html");
} elseif ($do == "update") {
    include_once("../public/authentication.php");
    try {
        update();
        header("location:?do=sucess");
    } catch (Exception $e) {
        header("location:?do=error");
    }
} elseif ($do == "executeOperation") {
    include_once("../public/authentication.php");

    executeOperation();

    $storeData = show();
    $smarty->assign("storeData", $storeData);

    $smarty->display("sparePartview/show.html");

    $smarty->assign("customCheck", 1);
} elseif ($do == "sucess") {
    //here the smarty templates
    $smarty->display("succes.html");
} elseif ($do == "error") {
    //here the smarty templates
    $smarty->display("error.html");
}
$smarty->assign("customValidation", 1);
//here the global templates
$smarty->display("footer.html");

/* ===============================
  function in this CONTROLLER
  ================================ */

// add in sparepart tbl
function add() {
    //to use the variable out side the funcion
    global $sparePart;
    global $sparePartDAO;
    global $sparePartDetail;
    global $sparePartDetailDAO;
    global $sparePartReport;
    global $sparePartReportDAO;

    $sparepartname = $_POST['sparepartname'];
    $sparepartprice = $_POST['sparepartprice'];
    $partquantity = $_POST['partquantity'];
    $sparepartnotes = $_POST['sparepartnotes'];

    $sparePart->conditions = 0;
    $sparePart->sparepartdate = date("Y-m-d");
    $sparePart->sparepartname = $sparepartname;
    $sparePart->sparepartnotes = $sparepartnotes;
    $sparePart->sparepartprice = $sparepartprice;
    $sparePart->userid = $_SESSION["userid"];

    $sparepartid = $sparePartDAO->insert($sparePart);
    if (isset($sparepartid)) {
        //insert into sparepartstoredetails table
        $sparePartDetail->partquantity = $partquantity;
        $sparePartDetail->sparepartid = $sparepartid;
        $sparePartDetail->sparepartstoredetaildate = date("Y-m-d");
        $sparePartDetail->sparepartstoreId = 1;
        $sparePartDetail->userid = $_SESSION["userid"];
        ;

        $sparePartDetailDAO->insert($sparePartDetail);

        //insert into sparepartstorereport
        $sparePartReport->partafter = $partquantity;
        $sparePartReport->partbefore = 0;
        $sparePartReport->partquantity = $partquantity;
        $sparePartReport->processname = "إضافة قطع غيار";
        $sparePartReport->sparepartid = $sparepartid;
        $sparePartReport->sparepartstoreId = 1;
        $sparePartReport->storereportdate = date("Y-m-d");
        $sparePartReport->storereportmodelid = $sparepartid;
        $sparePartReport->storereporttype = 0;
        $sparePartReport->tablename = "sparePartController.php";
        $sparePartReport->userid = $_SESSION['userid'];

        $sparePartReportDAO->insert($sparePartReport);
    }
}

//show
function show() {
    global $sparePartExt;
    global $sparePartDetailDAO;
    global $sparePartDetailExt;
    global $smarty;

    // required connect
    SmartyPaginate::connect();
    // set items per page
    SmartyPaginate::setLimit(25);

    //select all data from Supplier tbl
    // get the all colums number
    $allColums = $sparePartExt->queryAllExt();

    SmartyPaginate::setTotal(count($allColums));
    //get the selected data with limitation
    $sparePartsData = $sparePartExt->queryAllExtLimited(SmartyPaginate::getCurrentIndex(), SmartyPaginate::getLimit());

    // assign your db results to the template
    $smarty->assign('sparePartsData', $sparePartsData);
    // assign {$paginate} var
    SmartyPaginate::assign($smarty);
    //text that show in navgation
    SmartyPaginate::setNextText('التالى');
    SmartyPaginate::setPrevText('السابق');
    //add any varaible in url
    SmartyPaginate::setUrl('sparePartController.php?do=show&');
}

//show
function delete($sparePartId) {
    global $sparePartDAO;
    global $sparePartDetailDAO;

    if (!empty($sparePartId)) {
        $sparePartDAO->delete($sparePartId);
    }
}

//deletetemp Store tbl
function deletetemp($sparePartId) {
    //to use the variable out side the funcion
    global $sparePart;
    global $sparePartExt;

    try {
        if (!empty($sparePartId)) {
            $sparePart->conditions = 1;
            $sparePart->sparepartdate = date("Y-m-d");
            $sparePart->userid = $_SESSION["userid"];
            $sparePart->sparepartid = $sparePartId;

            $sparePartExt->updateConditions($sparePart);

            $note = "success";
        } else {
            $note = "حدث خطأ أثناء إخفاء القطعة";
        }
    } catch (Exception $e) {
        $note = "حدث خطأ أثناء إخفاء القطعة";
    }
    return $note;
}

//returndelete Store tbl
function returndelete($sparePartId) {
    global $sparePart;
    global $sparePartExt;

    try {
        if (!empty($sparePartId)) {
            $sparePart->conditions = 0;
            $sparePart->sparepartdate = date("Y-m-d");
            $sparePart->userid = $_SESSION["userid"];
            $sparePart->sparepartid = $sparePartId;

            $sparePartExt->updateConditions($sparePart);

            $note = "success";
        } else {
            $note = "حدث خطأ أثناء إظهار القطعة";
        }
    } catch (Exception $e) {
        $note = "حدث خطأ أثناء إظهار القطعة";
    }
    return $note;
}

//edit from Store tbl
function edit() {
    global $sparePartExt;
    global $sparePartDetailDAO;

    //get Variable
    $sparepartid = $_GET['id'];
    $loadData = $sparePartExt->loadExt($sparepartid);

    return $loadData;
}

function update() {
    global $sparePart;
    global $sparePartDAO;
    global $sparePartDetail;
    global $sparePartDetailDAO;
    global $sparePartDetailExt;
    global $sparePartReport;
    global $sparePartReportDAO;

    $sparepartid = $_POST['sparepartid'];
    $sparepartname = $_POST['sparepartname'];
    $sparepartprice = $_POST['sparepartprice'];
    $partquantity = $_POST['partquantity'];
    $sparepartnotes = $_POST['sparepartnotes'];
    $delete = $_POST['delete'];
    $h_partquantity = $_POST['h_partquantity'];

    $sparePart->conditions = $delete;
    ;
    $sparePart->sparepartdate = date("Y-m-d");
    $sparePart->sparepartname = $sparepartname;
    $sparePart->sparepartnotes = $sparepartnotes;
    $sparePart->sparepartprice = $sparepartprice;
    $sparePart->userid = $_SESSION["userid"];
    $sparePart->sparepartid = $sparepartid;

    $sparePartDAO->update($sparePart);
    if (isset($sparepartid)) {
        $detail = $sparePartDetailDAO->queryBySparepartid($sparepartid);
        if (count($detail) > 0) {//one row
            foreach ($detail as $d) {
                //update quantity in sparepartstoredetails table
                $sparePartDetail->partquantity = $partquantity;
                $sparePartDetail->sparepartid = $sparepartid;
                $sparePartDetail->sparepartstoredetaildate = date("Y-m-d");
                $sparePartDetail->sparepartstoreId = 1;
                $sparePartDetail->userid = $_SESSION["userid"];
                ;
                $sparePartDetail->sparepartstoredetailid = $d->sparepartstoredetailid;

                $sparePartDetailDAO->update($sparePartDetail);

                if ($h_partquantity > $partquantity) {
                    $sparePartReport->storereporttype = 1;
                    $sparePartReport->partquantity = $h_partquantity - $partquantity;
                } else {
                    $sparePartReport->storereporttype = 0;
                    $sparePartReport->partquantity = $partquantity - $h_partquantity;
                }
                //insert into sparepartstorereport
                $sparePartReport->partafter = $partquantity;
                $sparePartReport->partbefore = $h_partquantity;
                $sparePartReport->processname = "تعديل قطع غيار";
                $sparePartReport->sparepartid = $sparepartid;
                $sparePartReport->sparepartstoreId = 1;
                $sparePartReport->storereportdate = date("Y-m-d");
                $sparePartReport->storereportmodelid = $sparepartid;
                $sparePartReport->tablename = "sparePartController.php";
                $sparePartReport->userid = $_SESSION['userid'];

                $sparePartReportDAO->insert($sparePartReport);
            }
        }
    }
}

function executeOperation() {
    global $sparePartDAO;
    global $smarty;

    $outputString;

    $operationType = $_POST['operation'];
    $smarty->assign("operationType", $operationType);

    $choosedItemArr = $_POST['choosedItem'];
    //print_r($choosedItemArr);
    if (count($choosedItemArr) > 0) {
        foreach ($choosedItemArr as $sparePartId) {
            //get store name
            $storeData = $sparePartDAO->load($sparePartId);
            $sparepartname = $storeData->sparepartname;

            if ($operationType == '1') {
                //tempdelete
                $note = deletetemp($sparePartId);
                if ($note != "success") {
                    $outputString .= $sparepartname . ": " . $note . "<br/>";
                } else {
                    $outputString .= $sparepartname . ": " . "تمت العملية بنجاح <br/>";
                }
            } elseif ($operationType == "2") {
                //returndelete
                $note = returndelete($sparePartId);
                if ($note != "success") {
                    $outputString .= $sparepartname . ": " . $note . "<br/>";
                } else {
                    $outputString .= $sparepartname . ": " . "تمت العملية بنجاح <br/>";
                }
            } elseif ($operationType == "3") {
                //delete
                $note = delete($sparePartId);

                if ($note[0] != "success") {
                    $outputString .= $sparepartname . ": " . $note[0] . "<br/>";
                } else {
                    $outputString .= $sparepartname . ": " . "تمت العملية بنجاح <br/>";
                }
            }
        }
        $smarty->assign("outputString", $outputString);
    }
}

?>