<?php

//the global file operation
session_start();
ob_start();
//global varable
global $showoutside;
include_once("dailyentryfun.php");

//to check if the page from .htacess
//$showoutside = $_GET['sn'];
// get the config file
include_once("../public/config.php");

//here the db files that include in the file
include("../public/include_dao.php");
//Supplier
require_once('../models/dao/SupplierDAO.class.php');
require_once('../models/dto/Supplier.class.php');
require_once('../models/mysql/SupplierMySqlDAO.class.php');
require_once('../models/mysql/ext/SupplierMySqlExtDAO.class.php');

//Supplierdebtchange
require_once('../models/dao/SupplierdebtchangeDAO.class.php');
require_once('../models/dto/Supplierdebtchange.class.php');
require_once('../models/mysql/SupplierdebtchangeMySqlDAO.class.php');
require_once('../models/mysql/ext/SupplierdebtchangeMySqlExtDAO.class.php');

//get the do the action
$do = $_GET['do'];

/* ======================

  Controller Name :- productController

  OPERTATION in Controller

  1- display add form, add supplier cat and supplier with ajax
  2- add in supplier tbl
  2.1- insert into supplier unit tbl
  2.2- insert into storedetail tbl
  2.3- insert new row into storereport tbl
  3- display show and tempdelete
  4- edit supplier
  5- update supplier
  5.1- update supplier tbl with supplierid
  5.2- delete supplier units associated to this supplier from productunit tbl, then insert it again

  ======================== */

//here goes the instances and general variables
//Supplier
$supplier = new Supplier();
$supplierDAO = new SupplierMySqlDAO();
$supplierExt = new SupplierMySqlExtDAO();

//Supplierdebtchange
$Supplierdebtchange = new Supplierdebtchange();
$SupplierdebtchangeDAO = new SupplierdebtchangeMySqlDAO();
$SupplierdebtchangeEX = new SupplierdebtchangeMySqlExtDAO();


//Dailyentry
$dailyEntry = new Dailyentry();
$dailyEntryDAO = new DailyentryMySqlDAO();
$dailyEntryEX = new DailyentryMySqlExtDAO();

//Dailyentrycreditor دائن
$dailyEntryCreditor = new Dailyentrycreditor();
$dailyEntryCreditorDAO = new DailyentrycreditorMySqlDAO();
$dailyEntryCreditorEX = new DailyentrycreditorMySqlExtDAO();

//Dailyentrydebtor مدين
$dailyEntryDebtor = new Dailyentrydebtor();
$dailyEntryDebtorDAO = new DailyentrydebtorMySqlDAO();
$dailyEntryDebtorEX = new DailyentrydebtorMySqlExtDAO();

//check and use the condition that suite this action
if (empty($do)) {
    //here the permssion check
    //here the smarty templates
    //$smarty->display("supplierview/add.html");
} elseif ($do == "add") {

    try {
        $addData = add();
        $flag = $addData[0];
        $supplierId = $addData[1];

        if ($flag == '0') {
//            $suppliersData = getSuppliers(); //undeleted suppliers
//            $smarty->assign("suppliersData", $suppliersData);

            if (isset($supplierId)) {
                $choosensupplier = $supplierDAO->load($supplierId);
//                $smarty->assign("choosensupplier", $choosensupplier);
                echo json_encode($choosensupplier);
            }
//            $smarty->display("buyBillview/supplier.html");
        } else {
            echo $flag;
        }
    } catch (Exception $e) {
        //header("location:?do=error");
    }
} elseif ($do == 'check') {
    $name = $_POST['name'];
    $suppData = $supplierDAO->queryBySuppliername($name);
    if (!empty($suppData)) {
        echo -1;
    } elseif (empty($suppData)) {
        echo 0;
    }
} elseif ($do == "checkData") {

    $category_id = filter_input(INPUT_POST, 'category_id');

    $data = $supplierExt->checkCategory($category_id);
//    var_dump($data);
    if (count($data) > 0) {
        echo 1;
    } else {
        echo 0;
    }
} else if ($do == 'select2supplier') {
    select2supplier();
}

/* ===============================
  function in this CONTROLLER
  ================================ */

function getSuppliers() {
    global $supplierDAO;
    $suppliersData = $supplierDAO->queryAll(); //queryByCondition(0);
    return $suppliersData;
}

function select2supplier() {
    global $supplierExt;

    $row_array = array();
    $return_arr = array();

    $name = $_GET['term']; //It could be product name or category name
    $withAddOption = (int) $_GET['withAddOption'];
    $withNakdi = (int) $_GET['withNakdi'];
    $limit = 15; //intval($_GET['page_limit']);
    //
    $queryString = '';
    if ($name[0] == "i") {
        $name = (int) str_replace('i', '', $name);
        $queryString . ' and conditions = 0 and supplierid = ' . $name . ' order by supplierid asc limit ' . $limit;
    } else {
        $queryString .= ' and conditions = 0 and (suppliername LIKE "%' . $name . '%" or supplierphone LIKE "%' . $name . '%") order by supplierid asc limit ' . $limit;
    }


    $supplierData = $supplierExt->queryAllWithQueryString($queryString);
    if ($withAddOption == 1) {
        $row_array['id'] = "-2";
        $row_array['text'] = "اضافة مورد جديد";
        array_push($return_arr, $row_array);
    }
    if (count($supplierData) > 0) {
        $i = 1;
        foreach ($supplierData as $data) {
            if ($data->supplierid == 1) {
                if ($withNakdi == 1) {
                    $row_array['id'] = $data->supplierid;
                    $row_array['text'] = $data->suppliername;
                    $row_array['sullpierCurrencyid'] = $data->sullpierCurrencyid;
                    array_push($return_arr, $row_array);
                }
            } else {
                $row_array['id'] = $data->supplierid;
                $row_array['text'] = $data->suppliername;
                $row_array['sullpierCurrencyid'] = $data->sullpierCurrencyid;
                array_push($return_arr, $row_array);
            }

            //if ($withAddOption == 1 && $i == 1) {
//            if ($withAddOption == 1 && $data->supplierid == 1) {
//                $row_array['id'] = "-2";
//                $row_array['text'] = "اضافة مورد جديد";
//                array_push($return_arr, $row_array);
//            }
            $i++;
        }
    }


//echo $return_arr;
    echo json_encode($return_arr);
}

// add in supplier tbl
function add() {
    global $supplierDAO;
    global $supplier;

    global $Supplierdebtchange;
    global $SupplierdebtchangeDAO;

    //Dailyentry
    global $dailyEntry;
    global $dailyEntryDAO;

    //Dailyentrycreditor دائن
    global $dailyEntryCreditor;
    global $dailyEntryCreditorDAO;

    //Dailyentrydebtor مدين
    global $dailyEntryDebtor;
    global $dailyEntryDebtorDAO;

    global $today;
    $flag = '';
    $suppliername = $_POST["txtName"];
    $supplieraddress = $_POST["txtAddress"];
    $supplierphone = $_POST["txtPhone"];
    $supplierdetails = $_POST["textDetails"];
    $suppliercurrentDebt = $_POST["txtDebt"];
    $supplierTypeForTree = (int) $_POST["supplierTypeForTree"];
    $supplierdate = date("Y-m-d H:i:s");

    if (!empty($suppliername)) {
        //check if this name already exists
        if (count($supplierDAO->queryBySuppliername($suppliername)) == 0) {
            $supplier->suppliername = $suppliername;
            $supplier->supplieraddress = $supplieraddress;
            $supplier->supplierphone = $supplierphone;
            $supplier->supplierdetails = $supplierdetails;
            $supplier->suppliercurrentDebt = $suppliercurrentDebt;
            $supplier->userid = $_SESSION['userid'];
            $supplier->conditions = 0;
            $supplier->supplierdate = $supplierdate;
            $supplier->supplierTypeForTree = $supplierTypeForTree;
            $supplier->sullpierCurrencyid = 1;
            $supplier->suppliercurrentDebtInCurrency = $suppliercurrentDebt;
            $supplier->dailyentryid = 0;

            //Insert
            $supplierId = $supplierDAO->insert($supplier);



            if (!empty($supplierId)) {
                $Supplierdebtchange->comment = "";
                $Supplierdebtchange->processname = "إضافة مورد جديد";
                $Supplierdebtchange->supplierdebtchangeafter = $suppliercurrentDebt;
                $Supplierdebtchange->supplierdebtchangeamount = $suppliercurrentDebt;
                $Supplierdebtchange->supplierdebtchangebefore = 0;
                $Supplierdebtchange->supplierdebtchangedate = $supplierdate;
                $Supplierdebtchange->supplierdebtchangemodelid = $supplierId;
                $Supplierdebtchange->supplierid = $supplierId;
                $Supplierdebtchange->supplierdebtchangetype = 0;
                $Supplierdebtchange->tablename = "supplierController.php";
                $Supplierdebtchange->userid = $_SESSION['userid'];
                $Supplierdebtchange->dailyentryid = 0;

                $SupplierdebtchangeDAO->insert($Supplierdebtchange);
            }

            $flag = '0';
        } else {
            $flag = '2';
        }
    } else {
        $flag = '1';
    }
    $dailyEntry->entryComment = 'إضافة مورد ' . $suppliername;

    // start Ras L Maaal
    $dailyEntryDebtorArray = array();
    $dailyEntryDebtor->value = $suppliercurrentDebt;
    $dailyEntryDebtor->accountstreeid = 121;
    /// end Ras L Maaal
    //
    /// start L 7sab L da2non
    $dailyEntryCreditorArray = array();
    $dailyEntryCreditor->value = $suppliercurrentDebt;

    if ($supplierTypeForTree == 0)
        $parent = 81;
    elseif ($supplierTypeForTree == 1)
        $parent = 87;
    $treeId = addTreeElement($suppliername, $parent, 1, 0, 1, '', 0, 0);
    $dailyEntryCreditor->accountstreeid = $treeId;
    /// end L 7sab L da2non

    array_push($dailyEntryDebtorArray, $dailyEntryDebtor);
    array_push($dailyEntryCreditorArray, $dailyEntryCreditor);

    $returnedData = insertEntery($dailyEntry, $dailyEntryDebtorArray, $dailyEntryCreditorArray);
    $did = $returnedData[1];

    $rowData = $supplierDAO->load($supplierId);

    $rowData->dailyentryid = $did;
    $rowData->treeId = $treeId;

    $supplierDAO->update($rowData);
    return array($flag, $supplierId);
}

?>