<?php

//the global file operation
include("../public/impOpreation.php");
//global varable
global $showoutside;

//to check if the page from .htacess
//$showoutside = $_GET['sn'];
// get the config file
include_once("../public/config.php");

//here the db files that include in the file
include("../public/include_dao.php");

//Tamweenbill
require_once('../models/dao/TamweenbillDAO.class.php');
require_once('../models/dto/Tamweenbill.class.php');
require_once('../models/mysql/TamweenbillMySqlDAO.class.php');
require_once('../models/mysql/ext/TamweenbillMySqlExtDAO.class.php');
//Tamweenclientdetail
require_once('../models/dao/TamweenclientdetailDAO.class.php');
require_once('../models/dto/Tamweenclientdetail.class.php');
require_once('../models/mysql/TamweenclientdetailMySqlDAO.class.php');
require_once('../models/mysql/ext/TamweenclientdetailMySqlExtDAO.class.php');
//Tamweenda3mstatus
require_once('../models/dao/Tamweenda3mstatusDAO.class.php');
require_once('../models/dto/Tamweenda3mstatu.class.php');
require_once('../models/mysql/Tamweenda3mstatusMySqlDAO.class.php');
require_once('../models/mysql/ext/Tamweenda3mstatusMySqlExtDAO.class.php');
//Client
require_once('../models/dao/ClientDAO.class.php');
require_once('../models/dto/Client.class.php');
require_once('../models/mysql/ClientMySqlDAO.class.php');
require_once('../models/mysql/ext/ClientMySqlExtDAO.class.php');

require_once('../models/dao/YoutubeLinkDAO.class.php');
require_once('../models/dto/YoutubeLink.class.php');
require_once('../models/mysql/YoutubeLinkMySqlDAO.class.php');
require_once('../models/mysql/ext/YoutubeLinkMySqlExtDAO.class.php');

//get the do the action
$do = $_GET['do'];
$langs = $_SESSION['erp_lang'];
include_once("../views/languages/$langs/success.php");
include_once("../views/languages/$langs/error.php");
/* ======================
  Controller Name :-
  ======================== */

//here the global templates
$smarty->display("header.html");


//Tamweenbill
$tamweenBill = new Tamweenbill();
$tamweenBillDAO = new TamweenbillMySqlDAO();
$tamweenBillEX = new TamweenbillMySqlExtDAO();
//Tamweenclientdetail
$tamweenClientDetail = new Tamweenclientdetail();
$tamweenClientDetailDAO = new TamweenclientdetailMySqlDAO();
$tamweenClientDetailEX = new TamweenclientdetailMySqlExtDAO();
//Tamweenda3mstatus
$tamweenDa3mStatus = new Tamweenda3mstatu();
$tamweenDa3mStatusDAO = new Tamweenda3mstatusMySqlDAO();
$tamweenDa3mStatusEX = new Tamweenda3mstatusMySqlExtDAO();
//Client
$client = new Client();
$clientDAO = new ClientMySqlDAO();
$clientExt = new ClientMySqlExtDAO();

$youtubeLink = new YoutubeLink();
$youtubeLinkDAO = new YoutubeLinkMySqlDAO();
$youtubeLinkEX = new YoutubeLinkMySqlExtDAO();
//here goes the instances and general variables
$Programsettingdata = $ProgramsettingDAO->load(1);
$Programsettingdata->vatValue = (float) $Programsettingdata->vatValue;
$smarty->assign("Programsettingdata", $Programsettingdata);
//check and use the condition that suite this action
if (empty($do)) {
    //here the permssion check
    include_once("../public/authentication.php");

    $smarty->assign("statusData", $statusData);
    //here the smarty templates
    $smarty->display("tamweenbillview/add.html");
} elseif ($do == "add") {
    //here the permssion check
    include_once("../public/authentication.php");
    try {
        $id = add();
        //header("location:?do=sucess");
        header("location:?do=print&id=$id");
    } catch (Exception $e) {
        //echo $e;
        header("location:?do=error");
    }
} elseif ($do == "show") {
    //here the permssion check
    include_once("../public/authentication.php");

    $alldata = $clientDAO->queryByCondition(0);
    $smarty->assign("alldata", $alldata);

    $youtubes = $youtubeLinkDAO->queryAll();
    $smarty->assign("youtubes", $youtubes);

    $clientid = (int) filter_input(INPUT_POST, 'clientid');
    $from = filter_input(INPUT_POST, 'from');
    $to = filter_input(INPUT_POST, 'to');
    $clientCode = filter_input(INPUT_POST, 'clientCode');
    $clientPhone = filter_input(INPUT_POST, 'clientPhone');
    $clientMobile = filter_input(INPUT_POST, 'clientMobile');

    $queryString = '';
    if ($clientid > 0) {
        $queryString .=" and client.clientid = $clientid ";
    }
    if (!empty($from)) {
        $queryString .=" and date(billdate) >= '" . $from . "' ";
    }
    if (!empty($to)) {
        $queryString .=" and date(billdate) <= '" . $to . "' ";
    }
    if (!empty($clientCode)) {
        $queryString .=" and client.clientcode = '" . $clientCode . "' ";
    }
    if (!empty($clientPhone)) {
        $queryString .=" and client.clientphone = '" . $clientPhone . "' ";
    }
    if (!empty($clientMobile)) {
        $queryString .=" and client.clientmobile = '" . $clientMobile . "' ";
    }

    if ($queryString == '') {
        $from = $to = date('Y-m-d');
        $queryString .=" and date(billdate) >= '" . $from . "' and date(billdate) <= '" . $to . "' ";
    }
    $queryString .=" and del = 0";
    $bills = $tamweenBillEX->queryAllEX($queryString);
    $smarty->assign("bills", $bills);

    //here the smarty templates
    $smarty->display("tamweenbillview/show.html");
} elseif ($do == "edit") {
    $id = (int) filter_input(INPUT_GET, 'id');
    $bill = $tamweenBillEX->loadEX($id);
    $smarty->assign("bill", $bill);
    $smarty->display("tamweenbillview/edit.html");
} elseif ($do == "update") {
    //here the permssion check
    include_once("../public/authentication.php");
    try {
        update();
        header("location:?do=sucess");
    } catch (Exception $e) {
        //echo $e;
        header("location:?do=error");
    }
} elseif ($do == "delete") {
    //here the permssion check
    include_once("../public/authentication.php");
    try {
        delete();
        header("location:?do=sucess");
    } catch (Exception $e) {
        //echo $e;
        header("location:?do=error");
    }
} elseif ($do == "print") {
    $id = (int) filter_input(INPUT_GET, 'id');
    $bill = $tamweenBillEX->loadEX($id);
    $smarty->assign("bill", $bill);

    $clientData = $clientDAO->load($bill->clientid);
    $monthDays = cal_days_in_month(CAL_GREGORIAN, date('m'), date('Y'));
    $noOfDaysCalc = $monthDays;
    if (date('Y-m') == date('Y-m', strtotime($clientData->addDate))) {
        $noOfDaysCalc = ($monthDays + 1) - (int) (explode('-', $clientData->addDate)[2]); //+1 to have day added in calculation
    }

    $tamweenClientDetail = $tamweenClientDetailDAO->queryByClientid($bill->clientid);
    $cardShare = 5 * $tamweenClientDetail[0]->noOfPersonsDa3m * $noOfDaysCalc;

    $from = date('Y-m-1');
    $to = date('Y-m-31');
    $cardTakenAmount = (int) $tamweenBillEX->getClientTakenAmountFromTo($bill->clientid, $from, $to);
    $remaining = $cardShare - $cardTakenAmount;
    $ret_arr = array('noOfPersonsDa3m' => $tamweenClientDetail[0]->noOfPersonsDa3m, 'cardShare' => $cardShare, 'cardTakenAmount' => $cardTakenAmount, 'remaining' => $remaining, 'cardNum' => $tamweenClientDetail[0]->cardNum, 'noOfPersonsDa3m' => $tamweenClientDetail[0]->noOfPersonsDa3m);
    $smarty->assign("ret_arr", $ret_arr);
    $smarty->assign("now", date('Y-m-d H:i:s'));
    $smarty->assign("today", date('Y-m-d'));

    $smarty->display("tamweenbillview/print.html");
} elseif ($do == "sucess") {
//here the smarty templates
    $smarty->display("succes.html");
} elseif ($do == "error") {
//here the smarty templates
    $smarty->display("error.html");
}



$smarty->assign("customValidation", 1);
$smarty->assign("customTamween", 1);

//here the global templates
$smarty->display("footer.html");

/* ===============================
  function in this CONTROLLER
  ================================ */

function add() {
    global $tamweenBill;
    global $tamweenBillDAO;
    global $tamweenDa3mStatus;
    global $tamweenDa3mStatusDAO;
    global $tamweenDa3mStatusEX;

    $clientid = (int) filter_input(INPUT_POST, "client");
    $quantity = (int) filter_input(INPUT_POST, "quantity");
    $comment = filter_input(INPUT_POST, "comment");

    $tamweenBill->clientid = $clientid;
    $tamweenBill->quantity = $quantity;
    $tamweenBill->billdate = $tamweenBill->sysdate = date('Y-m-d H:i:s');
    $tamweenBill->billMonthDays = cal_days_in_month(CAL_GREGORIAN, date('m'), date('Y'));
    $tamweenBill->comment = $comment;
    $tamweenBill->userid = $_SESSION['userid'];
    $tamweenBill->del = 0;
    $id = $tamweenBillDAO->insert($tamweenBill);

    $tamweenStatus = (int) filter_input(INPUT_POST, "tamweenStatus");
    if ($tamweenStatus == 1) {#########in bill can give tamween only,not take it back
        $tamweenDa3mStatus = $tamweenDa3mStatusEX->queryRowByClientAndMonth($clientid, date('Y-m-1'));
        if ($tamweenDa3mStatus->tamweenStatus != 1) { #########if status == 1 not allowed to change it
            $tamweenDa3mStatus->tamweenStatus = 1;
            $tamweenDa3mStatus->useridTamween = $_SESSION['userid'];
            $tamweenDa3mStatus->sysdateTamween = date('Y-m-d H:i:s');
            $tamweenDa3mStatus->del = 0;
            if (isset($tamweenDa3mStatus->id) && $tamweenDa3mStatus->id > 0) {
//            $tamweenDa3mStatus->id = $tamweenDa3mStatus->id;
                $tamweenDa3mStatusDAO->update($tamweenDa3mStatus);
            } else {
                $tamweenDa3mStatus->clientid = $clientid;
                $tamweenDa3mStatus->month = date('Y-m-1');
                $tamweenDa3mStatus->da3mStatus = (int) $tamweenDa3mStatus->da3mStatus;
                $tamweenDa3mStatus->userid = 0;
                $tamweenDa3mStatus->sysdate = '';
                $tamweenDa3mStatusDAO->insert($tamweenDa3mStatus);
            }
        }
    }
    return $id;
}

function update() {
    global $tamweenBill;
    global $tamweenBillDAO;

    $id = (int) filter_input(INPUT_POST, "id");
    $clientid = (int) filter_input(INPUT_POST, "client");
    $quantity = (int) filter_input(INPUT_POST, "quantity");
    $comment = filter_input(INPUT_POST, "comment");

//    $tamweenBillDAO->delete($id);
    $tamweenBill = $tamweenBillDAO->load($id);
    $tamweenBill->clientid = $clientid;
    $tamweenBill->quantity = $quantity;
//    $tamweenBill->billdate = $tamweenBill->sysdate = date('Y-m-d H:i:s');
//    $tamweenBill->billMonthDays = cal_days_in_month(CAL_GREGORIAN, date('m'), date('Y'));
    $tamweenBill->comment = $comment;
    $tamweenBill->userid = $_SESSION['userid'];
    $tamweenBillDAO->update($tamweenBill);
}

function delete() {
    global $tamweenBill;
    global $tamweenBillDAO;

    $id = (int) filter_input(INPUT_GET, "id");
    $tamweenBillDAO->delete($id);
    //$tamweenBillDAO->update($tamweenBill);
}

?>