<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2021-08-23 23:52
 */
interface AccountmovementkindDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Accountmovementkind 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param accountmovementkind primary key
 	 */
	public function delete($accountmovementkindid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Accountmovementkind accountmovementkind
 	 */
	public function insert($accountmovementkind);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Accountmovementkind accountmovementkind
 	 */
	public function update($accountmovementkind);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByAccountmovementkindname($value);

	public function queryByAccountmovementkinddate($value);

	public function queryByUserid($value);

	public function queryByTablename($value);

	public function queryByConditions($value);

	public function queryByAccountmovementkindcomment($value);


	public function deleteByAccountmovementkindname($value);

	public function deleteByAccountmovementkinddate($value);

	public function deleteByUserid($value);

	public function deleteByTablename($value);

	public function deleteByConditions($value);

	public function deleteByAccountmovementkindcomment($value);


}
?>