<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
interface BankDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Bank 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param bank primary key
 	 */
	public function delete($bankid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Bank bank
 	 */
	public function insert($bank, $bankdetails);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Bank bank
 	 */
	public function update($bank, $bankdetails);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByBankname($value);

	public function queryByBankdetails($value);

	public function queryByUserid($value);

	public function queryByCondition($value);

	public function queryByBankdate($value);


	public function deleteByBankname($value);

	public function deleteByBankdetails($value);

	public function deleteByUserid($value);

	public function deleteByCondition($value);

	public function deleteByBankdate($value);


}
?>