<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2022-08-14 15:43
 */
interface BilloperationDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Billoperation 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param billoperation primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Billoperation billoperation
 	 */
	public function insert($billoperation);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Billoperation billoperation
 	 */
	public function update($billoperation);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByName($value);

	public function queryByUserid($value);

	public function queryBySydate($value);

	public function queryByDel($value);


	public function deleteByName($value);

	public function deleteByUserid($value);

	public function deleteBySydate($value);

	public function deleteByDel($value);


}
?>