<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2017-02-20 09:05
 */
interface BillsproductsbuyDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Billsproductsbuy 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param billsproductsbuy primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Billsproductsbuy billsproductsbuy
 	 */
	public function insert($billsproductsbuy);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Billsproductsbuy billsproductsbuy
 	 */
	public function update($billsproductsbuy);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByBillid($value);

	public function queryByProductid($value);

	public function queryByNote($value);

	public function queryByProductno($value);

	public function queryByProductprice($value);

	public function queryByProducttotalprice($value);

	public function queryByDeleted($value);

	public function queryByService($value);

	public function queryByRetproductno($value);

	public function queryByRondomtxt($value);

	public function queryByLastbuyprice($value);

	public function queryByMeanbuyprice($value);

	public function queryByStoreid($value);


	public function deleteByBillid($value);

	public function deleteByProductid($value);

	public function deleteByNote($value);

	public function deleteByProductno($value);

	public function deleteByProductprice($value);

	public function deleteByProducttotalprice($value);

	public function deleteByDeleted($value);

	public function deleteByService($value);

	public function deleteByRetproductno($value);

	public function deleteByRondomtxt($value);

	public function deleteByLastbuyprice($value);

	public function deleteByMeanbuyprice($value);

	public function deleteByStoreid($value);


}
?>