<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2022-05-25 03:14
 */
interface BilltemplateDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Billtemplate 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param billtemplate primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Billtemplate billtemplate
 	 */
	public function insert($billtemplate);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Billtemplate billtemplate
 	 */
	public function update($billtemplate);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByName($value);

	public function queryByUserid($value);

	public function queryBySysdate($value);

	public function queryByDel($value);


	public function deleteByName($value);

	public function deleteByUserid($value);

	public function deleteBySysdate($value);

	public function deleteByDel($value);


}
?>