<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
interface CapitalDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Capital 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param capital primary key
 	 */
	public function delete($capitalid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Capital capital
 	 */
	public function insert($capital);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Capital capital
 	 */
	public function update($capital);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByCapitalamount($value);


	public function deleteByCapitalamount($value);


}
?>