<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2014-11-24 10:38
 */
interface ClientareaDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Clientarea 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param clientarea primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Clientarea clientarea
 	 */
	public function insert($clientarea);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Clientarea clientarea
 	 */
	public function update($clientarea);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByName($value);

	public function queryByComment($value);


	public function deleteByName($value);

	public function deleteByComment($value);


}
?>