<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2016-06-21 12:09
 */
interface ClinicDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Clinic 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param clinic primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Clinic clinic
 	 */
	public function insert($clinic);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Clinic clinic
 	 */
	public function update($clinic);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByName($value);

	public function queryByDescription($value);

	public function queryByTempdel($value);


	public function deleteByName($value);

	public function deleteByDescription($value);

	public function deleteByTempdel($value);


}
?>