<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2020-10-19 19:01
 */
interface CollectedparcodestempDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Collectedparcodestemp 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param collectedparcodestemp primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Collectedparcodestemp collectedparcodestemp
 	 */
	public function insert($collectedparcodestemp);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Collectedparcodestemp collectedparcodestemp
 	 */
	public function update($collectedparcodestemp);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByUserid($value);

	public function queryBySellerid($value);

	public function queryByParcodes($value);

	public function queryBySysdate($value);

	public function queryByConditions($value);


	public function deleteByUserid($value);

	public function deleteBySellerid($value);

	public function deleteByParcodes($value);

	public function deleteBySysdate($value);

	public function deleteByConditions($value);


}
?>