<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2020-04-21 22:17
 */
interface CommentclientDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Commentclient 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param commentclient primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Commentclient commentclient
 	 */
	public function insert($commentclient);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Commentclient commentclient
 	 */
	public function update($commentclient);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByClientid($value);

	public function queryByUserid($value);

	public function queryByComments($value);

	public function queryByCommentdate($value);


	public function deleteByClientid($value);

	public function deleteByUserid($value);

	public function deleteByComments($value);

	public function deleteByCommentdate($value);


}
?>