<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2012-07-26 17:38
 */
interface ComplementpurchasebillDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Complementpurchasebill 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param complementpurchasebill primary key
 	 */
	public function delete($complementpurchasebillid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Complementpurchasebill complementpurchasebill
 	 */
	public function insert($complementpurchasebill);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Complementpurchasebill complementpurchasebill
 	 */
	public function update($complementpurchasebill);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByRawmaterialid($value);

	public function queryByRawmaterialprice($value);

	public function queryByRawmaterialamount($value);

	public function queryByRawmaterialdisount($value);

	public function queryByComplementpurchasebilltotal($value);


	public function deleteByRawmaterialid($value);

	public function deleteByRawmaterialprice($value);

	public function deleteByRawmaterialamount($value);

	public function deleteByRawmaterialdisount($value);

	public function deleteByComplementpurchasebilltotal($value);


}
?>