<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2023-07-22 14:39
 */
interface EmployeedoctorDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Employeedoctor 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param employeedoctor primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Employeedoctor employeedoctor
 	 */
	public function insert($employeedoctor);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Employeedoctor employeedoctor
 	 */
	public function update($employeedoctor);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByThetype($value);

	public function queryByName($value);

	public function queryByVal($value);

	public function queryByTreeId($value);

	public function queryByDailyentryid($value);

	public function queryByUserid($value);

	public function queryBySysdate($value);

	public function queryByDel($value);


	public function deleteByThetype($value);

	public function deleteByName($value);

	public function deleteByVal($value);

	public function deleteByTreeId($value);

	public function deleteByDailyentryid($value);

	public function deleteByUserid($value);

	public function deleteBySysdate($value);

	public function deleteByDel($value);


}
?>