<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2023-07-22 14:39
 */
interface EmployeedoctordebtchangeDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Employeedoctordebtchange 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param employeedoctordebtchange primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Employeedoctordebtchange employeedoctordebtchange
 	 */
	public function insert($employeedoctordebtchange);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Employeedoctordebtchange employeedoctordebtchange
 	 */
	public function update($employeedoctordebtchange);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByEmployeeOrDoctor($value);

	public function queryByEmployeeOrDoctorId($value);

	public function queryByDebtchangebefore($value);

	public function queryByDebtchangeamount($value);

	public function queryByDebtchangetype($value);

	public function queryByProcessname($value);

	public function queryByDebtchangemodelid($value);

	public function queryByDebtchangeafter($value);

	public function queryByDebtchangedate($value);

	public function queryByUserid($value);

	public function queryByTablename($value);

	public function queryByComment($value);

	public function queryByDel($value);

	public function queryByDailyentryid($value);

	public function queryBySaveid($value);


	public function deleteByEmployeeOrDoctor($value);

	public function deleteByEmployeeOrDoctorId($value);

	public function deleteByDebtchangebefore($value);

	public function deleteByDebtchangeamount($value);

	public function deleteByDebtchangetype($value);

	public function deleteByProcessname($value);

	public function deleteByDebtchangemodelid($value);

	public function deleteByDebtchangeafter($value);

	public function deleteByDebtchangedate($value);

	public function deleteByUserid($value);

	public function deleteByTablename($value);

	public function deleteByComment($value);

	public function deleteByDel($value);

	public function deleteByDailyentryid($value);

	public function deleteBySaveid($value);


}
?>