<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2020-11-11 22:24
 */
interface EmployeegroupDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Employeegroup 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param employeegroup primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Employeegroup employeegroup
 	 */
	public function insert($employeegroup);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Employeegroup employeegroup
 	 */
	public function update($employeegroup);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByName($value);

	public function queryByEmployeeattendancesystemid($value);

	public function queryByUserid($value);

	public function queryByDel($value);

	public function queryBySysdate($value);


	public function deleteByName($value);

	public function deleteByEmployeeattendancesystemid($value);

	public function deleteByUserid($value);

	public function deleteByDel($value);

	public function deleteBySysdate($value);


}
?>