<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
interface ExpensesDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Expenses 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param expense primary key
 	 */
	public function delete($expensesid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Expenses expense
 	 */
	public function insert($expense);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Expenses expense
 	 */
	public function update($expense);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByExpensestypeid($value);

	public function queryByExpensesname($value);

	public function queryByExpensesdetails($value);

	public function queryByExpensesValue($value);

	public function queryByExpensesdate($value);

	public function queryByUserid($value);

	public function queryByCondition($value);


	public function deleteByExpensestypeid($value);

	public function deleteByExpensesname($value);

	public function deleteByExpensesdetails($value);

	public function deleteByExpensesValue($value);

	public function deleteByExpensesdate($value);

	public function deleteByUserid($value);

	public function deleteByCondition($value);


}
?>