<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2016-06-21 11:00
 */
interface InsurancecompaniesDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Insurancecompanies 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param insurancecompanie primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Insurancecompanies insurancecompanie
 	 */
	public function insert($insurancecompanie);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Insurancecompanies insurancecompanie
 	 */
	public function update($insurancecompanie);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByName($value);

	public function queryByDiscountpercent($value);

	public function queryByContractstart($value);

	public function queryByContractend($value);

	public function queryByContractphoto($value);

	public function queryByInstruction($value);

	public function queryByDeleted($value);

	public function queryByUserid($value);


	public function deleteByName($value);

	public function deleteByDiscountpercent($value);

	public function deleteByContractstart($value);

	public function deleteByContractend($value);

	public function deleteByContractphoto($value);

	public function deleteByInstruction($value);

	public function deleteByDeleted($value);

	public function deleteByUserid($value);


}
?>