<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
interface KempialaDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Kempiala 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param kempiala primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Kempiala kempiala
 	 */
	public function insert($kempiala);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Kempiala kempiala
 	 */
	public function update($kempiala);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByClientID($value);

	public function queryByRecievingdate($value);

	public function queryByValue($value);

	public function queryByClientcomment($value);

	public function queryBySelling($value);

	public function queryByExpiredate($value);

	public function queryBySupplierID($value);

	public function queryBySellingdate($value);

	public function queryByCondition($value);

	public function queryBySuppliercomment($value);


	public function deleteByClientID($value);

	public function deleteByRecievingdate($value);

	public function deleteByValue($value);

	public function deleteByClientcomment($value);

	public function deleteBySelling($value);

	public function deleteByExpiredate($value);

	public function deleteBySupplierID($value);

	public function deleteBySellingdate($value);

	public function deleteByCondition($value);

	public function deleteBySuppliercomment($value);


}
?>