<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2023-09-11 09:10
 */
interface KnownwaysDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Knownways 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param knownway primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Knownways knownway
 	 */
	public function insert($knownway);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Knownways knownway
 	 */
	public function update($knownway);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByName($value);


	public function deleteByName($value);


}
?>