<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2014-04-15 14:14
 */
interface ManufacuresettingDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Manufacuresetting 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param manufacuresetting primary key
 	 */
	public function delete($manufacuresettingid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Manufacuresetting manufacuresetting
 	 */
	public function insert($manufacuresetting);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Manufacuresetting manufacuresetting
 	 */
	public function update($manufacuresetting);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByOrdername($value);

	public function queryByExcahangeorder($value);


	public function deleteByOrdername($value);

	public function deleteByExcahangeorder($value);


}
?>