<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2012-07-26 17:38
 */
interface MeasurementunitsDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Measurementunits 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param measurementunit primary key
 	 */
	public function delete($measurementunitid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Measurementunits measurementunit
 	 */
	public function insert($measurementunit);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Measurementunits measurementunit
 	 */
	public function update($measurementunit);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByMeasurementunitname($value);

	public function queryByMeasurementunitdescription($value);

	public function queryByTempdelete($value);

	public function queryByCurrentdate($value);


	public function deleteByMeasurementunitname($value);

	public function deleteByMeasurementunitdescription($value);

	public function deleteByTempdelete($value);

	public function deleteByCurrentdate($value);


}
?>