<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2019-09-24 12:56
 */
interface OfferorderDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Offerorder 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param offerorder primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Offerorder offerorder
 	 */
	public function insert($offerorder);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Offerorder offerorder
 	 */
	public function update($offerorder);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByDatenow($value);

	public function queryByUserid($value);

	public function queryByDel($value);

	public function queryByClient($value);

	public function queryByMydate($value);

	public function queryByAlltotal($value);

	public function queryByAllquantity($value);

	public function queryByAllquantstore($value);

	public function queryByPricestore($value);

	public function queryByAllquantavailable($value);

	public function queryByPriceavailable($value);

	public function queryByAllquantmiun($value);

	public function queryByPricemiun($value);

	public function queryByOldorder($value);

	public function queryByOldoffer($value);


	public function deleteByDatenow($value);

	public function deleteByUserid($value);

	public function deleteByDel($value);

	public function deleteByClient($value);

	public function deleteByMydate($value);

	public function deleteByAlltotal($value);

	public function deleteByAllquantity($value);

	public function deleteByAllquantstore($value);

	public function deleteByPricestore($value);

	public function deleteByAllquantavailable($value);

	public function deleteByPriceavailable($value);

	public function deleteByAllquantmiun($value);

	public function deleteByPricemiun($value);

	public function deleteByOldorder($value);

	public function deleteByOldoffer($value);


}
?>