<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2016-06-13 15:29
 */
interface OfferpricebillpropDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Offerpricebillprop 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param offerpricebillprop primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Offerpricebillprop offerpricebillprop
 	 */
	public function insert($offerpricebillprop);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Offerpricebillprop offerpricebillprop
 	 */
	public function update($offerpricebillprop);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByClientid($value);

	public function queryByClientname($value);

	public function queryByTotalprice($value);


	public function deleteByClientid($value);

	public function deleteByClientname($value);

	public function deleteByTotalprice($value);


}
?>