<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2019-11-27 14:34
 */
interface OnlinestoresettingDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Onlinestoresetting 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param onlinestoresetting primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Onlinestoresetting onlinestoresetting
 	 */
	public function insert($onlinestoresetting);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Onlinestoresetting onlinestoresetting
 	 */
	public function update($onlinestoresetting);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByUrl($value);

	public function queryByAvailableStores($value);

	public function queryByOnlinestoreid($value);

	public function queryByOnlineclientareaid($value);

	public function queryByUpdatetype($value);

	public function queryByCatprohour($value);

	public function queryByCatprominute($value);

	public function queryByProquantityhour($value);

	public function queryByProquantityminute($value);

	public function queryByClientshour($value);

	public function queryByClientsminute($value);


	public function deleteByUrl($value);

	public function deleteByAvailableStores($value);

	public function deleteByOnlinestoreid($value);

	public function deleteByOnlineclientareaid($value);

	public function deleteByUpdatetype($value);

	public function deleteByCatprohour($value);

	public function deleteByCatprominute($value);

	public function deleteByProquantityhour($value);

	public function deleteByProquantityminute($value);

	public function deleteByClientshour($value);

	public function deleteByClientsminute($value);


}
?>