<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2019-12-22 14:16
 */
interface OnlinetemporderclientDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Onlinetemporderclient 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param onlinetemporderclient primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Onlinetemporderclient onlinetemporderclient
 	 */
	public function insert($onlinetemporderclient);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Onlinetemporderclient onlinetemporderclient
 	 */
	public function update($onlinetemporderclient);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByErpid($value);

	public function queryByOrderid($value);

	public function queryByClientname($value);

	public function queryByClientcode($value);

	public function queryByClientmobile($value);

	public function queryByClientdebt($value);

	public function queryByClientaddress($value);

	public function queryByClientareaid($value);


	public function deleteByErpid($value);

	public function deleteByOrderid($value);

	public function deleteByClientname($value);

	public function deleteByClientcode($value);

	public function deleteByClientmobile($value);

	public function deleteByClientdebt($value);

	public function deleteByClientaddress($value);

	public function deleteByClientareaid($value);


}
?>