<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2019-11-16 10:42
 */
interface OnlinetempproductDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Onlinetempproduct 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param onlinetempproduct primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Onlinetempproduct onlinetempproduct
 	 */
	public function insert($onlinetempproduct);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Onlinetempproduct onlinetempproduct
 	 */
	public function update($onlinetempproduct);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByProductid($value);

	public function queryByEdited($value);

	public function queryBySysdate($value);

	public function queryByUserid($value);


	public function deleteByProductid($value);

	public function deleteByEdited($value);

	public function deleteBySysdate($value);

	public function deleteByUserid($value);


}
?>