<?php

/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2021-06-24 11:58
 */
interface PlaystationclientcardDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @Return Playstationclientcard
     */
    public function load($id);

    /**
     * Get all records from table
     */
    public function queryAll();

    /**
     * Get all records from table ordered by field
     * @Param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn);

    /**
     * Delete record from table
     * @param playstationclientcard primary key
     */
    public function delete($id);

    /**
     * Insert record to table
     *
     * @param Playstationclientcard playstationclientcard
     */
    public function insert($playstationclientcard);

    /**
     * Update record in table
     *
     * @param Playstationclientcard playstationclientcard
     */
    public function update($playstationclientcard);

    /**
     * Delete all rows
     */
    public function clean();

    public function queryByCardid($value);

    public function queryByClientid($value);

    public function queryByBuyDate($value);

    public function queryByPackVal($value);

    public function queryByPackPrice($value);

    public function queryByPackDays($value);

    public function queryByPackValConsumed($value);

    public function queryByCardEndDate($value);

    public function queryByCardStatus($value);

    public function queryByUserid($value);

    public function queryByDel($value);

    public function queryBySysDate($value);

    public function deleteByCardid($value);

    public function deleteByClientid($value);

    public function deleteByBuyDate($value);

    public function deleteByPackVal($value);

    public function deleteByPackPrice($value);

    public function deleteByPackDays($value);

    public function deleteByPackValConsumed($value);

    public function deleteByCardEndDate($value);

    public function deleteByCardStatus($value);

    public function deleteByUserid($value);

    public function deleteByDel($value);

    public function deleteBySysDate($value);
}

?>