<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2018-11-28 13:59
 */
interface ProductionexecutionDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Productionexecution 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param productionexecution primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Productionexecution productionexecution
 	 */
	public function insert($productionexecution);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Productionexecution productionexecution
 	 */
	public function update($productionexecution);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByOrderId($value);

	public function queryByTitle($value);

	public function queryByOrderdate($value);

	public function queryByTaskid($value);

	public function queryByProductid($value);

	public function queryByNum($value);

	public function queryByOutstoreid($value);

	public function queryByWastestoreid($value);

	public function queryByRentcost($value);

	public function queryByOthercost($value);

	public function queryByExecutioncost($value);

	public function queryBySysdate($value);


	public function deleteByOrderId($value);

	public function deleteByTitle($value);

	public function deleteByOrderdate($value);

	public function deleteByTaskid($value);

	public function deleteByProductid($value);

	public function deleteByNum($value);

	public function deleteByOutstoreid($value);

	public function deleteByWastestoreid($value);

	public function deleteByRentcost($value);

	public function deleteByOthercost($value);

	public function deleteByExecutioncost($value);

	public function deleteBySysdate($value);


}
?>