<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2018-11-28 13:59
 */
interface ProductionexecutionproductDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Productionexecutionproduct 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param productionexecutionproduct primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Productionexecutionproduct productionexecutionproduct
 	 */
	public function insert($productionexecutionproduct);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Productionexecutionproduct productionexecutionproduct
 	 */
	public function update($productionexecutionproduct);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByExecutionid($value);

	public function queryByProductid($value);

	public function queryByUnitid($value);

	public function queryByQuantity($value);

	public function queryByActualquantity($value);

	public function queryByCost($value);

	public function queryByActualcost($value);


	public function deleteByExecutionid($value);

	public function deleteByProductid($value);

	public function deleteByUnitid($value);

	public function deleteByQuantity($value);

	public function deleteByActualquantity($value);

	public function deleteByCost($value);

	public function deleteByActualcost($value);


}
?>