<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2022-10-26 23:15
 */
interface ProductionoutdetailsDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Productionoutdetails 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param productionoutdetail primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Productionoutdetails productionoutdetail
 	 */
	public function insert($productionoutdetail);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Productionoutdetails productionoutdetail
 	 */
	public function update($productionoutdetail);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByProductionOutId($value);

	public function queryByProductid($value);

	public function queryBySizeid($value);

	public function queryByColorid($value);

	public function queryByUnitid($value);

	public function queryByPrice($value);

	public function queryByQuantity($value);

	public function queryByInTotalCost($value);


	public function deleteByProductionOutId($value);

	public function deleteByProductid($value);

	public function deleteBySizeid($value);

	public function deleteByColorid($value);

	public function deleteByUnitid($value);

	public function deleteByPrice($value);

	public function deleteByQuantity($value);

	public function deleteByInTotalCost($value);


}
?>