<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2023-01-24 21:04
 */
interface ProductionoutmanyinproductsDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Productionoutmanyinproducts 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param productionoutmanyinproduct primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Productionoutmanyinproducts productionoutmanyinproduct
 	 */
	public function insert($productionoutmanyinproduct);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Productionoutmanyinproducts productionoutmanyinproduct
 	 */
	public function update($productionoutmanyinproduct);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByProductionoutmanyid($value);

	public function queryByProductid($value);

	public function queryBySizeid($value);

	public function queryByColorid($value);

	public function queryByProunitid($value);

	public function queryByQuantity($value);

	public function queryByUnitpriceraw($value);

	public function queryByUnitManufPrice($value);

	public function queryByInTotalCostUnit($value);

	public function queryByInTotalCost($value);


	public function deleteByProductionoutmanyid($value);

	public function deleteByProductid($value);

	public function deleteBySizeid($value);

	public function deleteByColorid($value);

	public function deleteByProunitid($value);

	public function deleteByQuantity($value);

	public function deleteByUnitpriceraw($value);

	public function deleteByUnitManufPrice($value);

	public function deleteByInTotalCostUnit($value);

	public function deleteByInTotalCost($value);


}
?>