<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2013-09-29 12:20
 */
interface ProductrecieveDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Productrecieve 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param productrecieve primary key
 	 */
	public function delete($productrecieveid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Productrecieve productrecieve
 	 */
	public function insert($productrecieve);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Productrecieve productrecieve
 	 */
	public function update($productrecieve);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryBySparepartid($value);

	public function queryByProductrecievedate($value);

	public function queryByRecieptnum($value);

	public function queryByClientname($value);

	public function queryByType($value);

	public function queryByCost($value);

	public function queryByPartsnumber($value);

	public function queryByUserid($value);


	public function deleteBySparepartid($value);

	public function deleteByProductrecievedate($value);

	public function deleteByRecieptnum($value);

	public function deleteByClientname($value);

	public function deleteByType($value);

	public function deleteByCost($value);

	public function deleteByPartsnumber($value);

	public function deleteByUserid($value);


}
?>