<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2013-05-07 12:40
 */
interface ProducttempDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Producttemp 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param producttemp primary key
 	 */
	public function delete($producttempid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Producttemp producttemp
 	 */
	public function insert($producttemp);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Producttemp producttemp
 	 */
	public function update($producttemp);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByProductName($value);

	public function queryByProductCatId($value);

	public function queryByProductBuyPrice($value);

	public function queryByProductSellAllPrice($value);

	public function queryByProductSellUnitPrice($value);

	public function queryByProductSellHalfPrice($value);

	public function queryByProductDate($value);

	public function queryByConditions($value);

	public function queryByUserId($value);

	public function queryByParcode($value);


	public function deleteByProductName($value);

	public function deleteByProductCatId($value);

	public function deleteByProductBuyPrice($value);

	public function deleteByProductSellAllPrice($value);

	public function deleteByProductSellUnitPrice($value);

	public function deleteByProductSellHalfPrice($value);

	public function deleteByProductDate($value);

	public function deleteByConditions($value);

	public function deleteByUserId($value);

	public function deleteByParcode($value);


}
?>