<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2016-06-21 12:04
 */
interface ProjectDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Project 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param project primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Project project
 	 */
	public function insert($project);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Project project
 	 */
	public function update($project);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByName($value);

	public function queryByTotalcontract($value);

	public function queryByImage($value);

	public function queryByDetail($value);

	public function queryByClientid($value);

	public function queryByCostcenterid($value);


	public function deleteByName($value);

	public function deleteByTotalcontract($value);

	public function deleteByImage($value);

	public function deleteByDetail($value);

	public function deleteByClientid($value);

	public function deleteByCostcenterid($value);


}
?>