<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2016-07-03 12:01
 */
interface ProjectexchmaterialreturnDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Projectexchmaterialreturn 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param projectexchmaterialreturn primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Projectexchmaterialreturn projectexchmaterialreturn
 	 */
	public function insert($projectexchmaterialreturn);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Projectexchmaterialreturn projectexchmaterialreturn
 	 */
	public function update($projectexchmaterialreturn);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryBySerilno($value);

	public function queryByProjectid($value);

	public function queryByStoreid($value);

	public function queryByProjdate($value);

	public function queryBySysdate($value);

	public function queryByTotalnum($value);

	public function queryByTotalbuyprice($value);

	public function queryByEntryid($value);


	public function deleteBySerilno($value);

	public function deleteByProjectid($value);

	public function deleteByStoreid($value);

	public function deleteByProjdate($value);

	public function deleteBySysdate($value);

	public function deleteByTotalnum($value);

	public function deleteByTotalbuyprice($value);

	public function deleteByEntryid($value);


}
?>