<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2021-09-11 21:40
 */
interface ProjectkindDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Projectkind 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param projectkind primary key
 	 */
	public function delete($projectkindid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Projectkind projectkind
 	 */
	public function insert($projectkind);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Projectkind projectkind
 	 */
	public function update($projectkind);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByProjectkindname($value);

	public function queryByProjectkinddate($value);

	public function queryByUserid($value);

	public function queryByConditions($value);

	public function queryByProjectkindcomment($value);


	public function deleteByProjectkindname($value);

	public function deleteByProjectkinddate($value);

	public function deleteByUserid($value);

	public function deleteByConditions($value);

	public function deleteByProjectkindcomment($value);


}
?>