<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2012-07-26 17:38
 */
interface RawmaterialsDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Rawmaterials 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param rawmaterial primary key
 	 */
	public function delete($rawmaterialid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Rawmaterials rawmaterial
 	 */
	public function insert($rawmaterial);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Rawmaterials rawmaterial
 	 */
	public function update($rawmaterial);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByRawmaterialname($value);

	public function queryByRawmaterialsdescription($value);

	public function queryByRawmaterialprice($value);

	public function queryByMeasurementunitid($value);

	public function queryByOpeningbalance($value);

	public function queryByRawmaterialscategoryid($value);

	public function queryByTempdelete($value);

	public function queryByCurrentdate($value);


	public function deleteByRawmaterialname($value);

	public function deleteByRawmaterialsdescription($value);

	public function deleteByRawmaterialprice($value);

	public function deleteByMeasurementunitid($value);

	public function deleteByOpeningbalance($value);

	public function deleteByRawmaterialscategoryid($value);

	public function deleteByTempdelete($value);

	public function deleteByCurrentdate($value);


}
?>