<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2018-05-16 11:38
 */
interface RestauranthallDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Restauranthall 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param restauranthall primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Restauranthall restauranthall
 	 */
	public function insert($restauranthall);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Restauranthall restauranthall
 	 */
	public function update($restauranthall);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByName($value);

	public function queryByHallUsers($value);

	public function queryByUserId($value);

	public function queryBySysdate($value);

	public function queryByDel($value);


	public function deleteByName($value);

	public function deleteByHallUsers($value);

	public function deleteByUserId($value);

	public function deleteBySysdate($value);

	public function deleteByDel($value);


}
?>