<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2018-12-04 14:10
 */
interface RestaurantorderdeliverydetailsDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Restaurantorderdeliverydetails 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param restaurantorderdeliverydetail primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Restaurantorderdeliverydetails restaurantorderdeliverydetail
 	 */
	public function insert($restaurantorderdeliverydetail);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Restaurantorderdeliverydetails restaurantorderdeliverydetail
 	 */
	public function update($restaurantorderdeliverydetail);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByOrderId($value);

	public function queryByClientId($value);

	public function queryByClientmobile($value);

	public function queryByClientphone($value);

	public function queryByClientaddress($value);

	public function queryByClientdetails($value);


	public function deleteByOrderId($value);

	public function deleteByClientId($value);

	public function deleteByClientmobile($value);

	public function deleteByClientphone($value);

	public function deleteByClientaddress($value);

	public function deleteByClientdetails($value);


}
?>