<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
interface ReturnbuybillDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Returnbuybill 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param returnbuybill primary key
 	 */
	public function delete($returnbuybillid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Returnbuybill returnbuybill
 	 */
	public function insert($returnbuybill);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Returnbuybill returnbuybill
 	 */
	public function update($returnbuybill);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByReturnbuybillSerial($value);

	public function queryByReturnbuybilldate($value);

	public function queryByReturnbuybillsupplierid($value);

	public function queryByReturnbuybilltotaldeptbefor($value);

	public function queryByReturnbuybilltotaldeptafter($value);

	public function queryByReturnbuybilldiscount($value);

	public function queryByReturnbuybilldiscountrype($value);

	public function queryByReturnbuybilltotalbill($value);

	public function queryByReturnbuybillaftertotalbill($value);

	public function queryByReturnbuybilltotalpayed($value);

	public function queryByReturnbuybillfinalbill($value);

	public function queryByReturnbuybillstoreid($value);

	public function queryByReturnbuybillsysdate($value);

	public function queryByUserid($value);

	public function queryByCondition($value);

	public function queryByReturnbuybillclientname($value);

	public function queryByReturnbuybillsaveid($value);

	public function queryByBillnameid($value);

	public function queryByReturnbuybilldirectpayment($value);


	public function deleteByReturnbuybillSerial($value);

	public function deleteByReturnbuybilldate($value);

	public function deleteByReturnbuybillsupplierid($value);

	public function deleteByReturnbuybilltotaldeptbefor($value);

	public function deleteByReturnbuybilltotaldeptafter($value);

	public function deleteByReturnbuybilldiscount($value);

	public function deleteByReturnbuybilldiscountrype($value);

	public function deleteByReturnbuybilltotalbill($value);

	public function deleteByReturnbuybillaftertotalbill($value);

	public function deleteByReturnbuybilltotalpayed($value);

	public function deleteByReturnbuybillfinalbill($value);

	public function deleteByReturnbuybillstoreid($value);

	public function deleteByReturnbuybillsysdate($value);

	public function deleteByUserid($value);

	public function deleteByCondition($value);

	public function deleteByReturnbuybillclientname($value);

	public function deleteByReturnbuybillsaveid($value);

	public function deleteByBillnameid($value);

	public function deleteByReturnbuybilldirectpayment($value);


}
?>