<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2014-04-01 11:09
 */
interface SettingoperationDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Settingoperation 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param settingoperation primary key
 	 */
	public function delete($settingOperationID);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Settingoperation settingoperation
 	 */
	public function insert($settingoperation);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Settingoperation settingoperation
 	 */
	public function update($settingoperation);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryBySettingOperationName($value);

	public function queryByWorkStationID($value);

	public function queryByRealTime($value);

	public function queryByAssetesID($value);

	public function queryByWorkersNo($value);

	public function queryByCondition($value);

	public function queryByUserID($value);

	public function queryByDate($value);


	public function deleteBySettingOperationName($value);

	public function deleteByWorkStationID($value);

	public function deleteByRealTime($value);

	public function deleteByAssetesID($value);

	public function deleteByWorkersNo($value);

	public function deleteByCondition($value);

	public function deleteByUserID($value);

	public function deleteByDate($value);


}
?>