<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2019-08-18 15:09
 */
interface SizecolorDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Sizecolor 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param sizecolor primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Sizecolor sizecolor
 	 */
	public function insert($sizecolor);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Sizecolor sizecolor
 	 */
	public function update($sizecolor);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByName($value);

	public function queryByType($value);

	public function queryByUserid($value);

	public function queryByConditions($value);

	public function queryBySysdate($value);


	public function deleteByName($value);

	public function deleteByType($value);

	public function deleteByUserid($value);

	public function deleteByConditions($value);

	public function deleteBySysdate($value);


}
?>