<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2012-07-26 17:38
 */
interface StorerawmaterialsDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Storerawmaterials 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param storerawmaterial primary key
 	 */
	public function delete($storerawmaterialsid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Storerawmaterials storerawmaterial
 	 */
	public function insert($storerawmaterial);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Storerawmaterials storerawmaterial
 	 */
	public function update($storerawmaterial);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByStorerawmaterialsname($value);

	public function queryByStorerawmaterialsdescription($value);

	public function queryByTempdelete($value);

	public function queryByCurrentdate($value);


	public function deleteByStorerawmaterialsname($value);

	public function deleteByStorerawmaterialsdescription($value);

	public function deleteByTempdelete($value);

	public function deleteByCurrentdate($value);


}
?>