<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2016-07-20 10:41
 */
interface SuppayDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Suppay 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param suppay primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Suppay suppay
 	 */
	public function insert($suppay);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Suppay suppay
 	 */
	public function update($suppay);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByIdsupdeptchange($value);

	public function queryByPaytype($value);


	public function deleteByIdsupdeptchange($value);

	public function deleteByPaytype($value);


}
?>