<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2020-12-14 16:01
 */
interface TamweenbillDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Tamweenbill 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tamweenbill primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Tamweenbill tamweenbill
 	 */
	public function insert($tamweenbill);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Tamweenbill tamweenbill
 	 */
	public function update($tamweenbill);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByClientid($value);

	public function queryByQuantity($value);

	public function queryByBilldate($value);

	public function queryByBillMonthDays($value);

	public function queryByComment($value);

	public function queryByUserid($value);

	public function queryBySysdate($value);

	public function queryByDel($value);


	public function deleteByClientid($value);

	public function deleteByQuantity($value);

	public function deleteByBilldate($value);

	public function deleteByBillMonthDays($value);

	public function deleteByComment($value);

	public function deleteByUserid($value);

	public function deleteBySysdate($value);

	public function deleteByDel($value);


}
?>