<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2021-01-02 07:30
 */
interface TamweenremainstatusDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Tamweenremainstatus 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tamweenremainstatu primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Tamweenremainstatus tamweenremainstatu
 	 */
	public function insert($tamweenremainstatu);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Tamweenremainstatus tamweenremainstatu
 	 */
	public function update($tamweenremainstatu);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByClientid($value);

	public function queryByMonth($value);

	public function queryByRemainstatus($value);

	public function queryByUserid($value);

	public function queryBySysdate($value);

	public function queryByDel($value);


	public function deleteByClientid($value);

	public function deleteByMonth($value);

	public function deleteByRemainstatus($value);

	public function deleteByUserid($value);

	public function deleteBySysdate($value);

	public function deleteByDel($value);


}
?>